/****************************************************************************
**
** Copyright (C) 2017 Klaralvdalens Datakonsult AB, a KDAB Group company, info@kdab.com, author David Faure <david.faure@kdab.com>
** Contact: https://www.qt.io/licensing/
**
** This file is part of the test suite of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/


#include <QtCore/QCoreApplication>
#include <QtTest/QtTest>

class tst_DeleteLater_noApp: public QObject
{
    Q_OBJECT

private slots:
    void qtestLibShouldNotFlushDeleteLaterBetweenTests_setup();
    void qtestLibShouldNotFlushDeleteLaterBetweenTests_check();
    void qtestLibShouldNotFlushDeleteLaterOnExit();
};

class ToBeDeleted : public QObject
{
public:
    ToBeDeleted(bool *staticBool) : staticBool(staticBool) {}
    ~ToBeDeleted() { *staticBool = true; }
private:
    bool *staticBool;
};

static bool deletedBetweenTests = false;

void tst_DeleteLater_noApp::qtestLibShouldNotFlushDeleteLaterBetweenTests_setup()
{
    ToBeDeleted *obj = new ToBeDeleted(&deletedBetweenTests);
    obj->deleteLater();
}

void tst_DeleteLater_noApp::qtestLibShouldNotFlushDeleteLaterBetweenTests_check()
{
    // There's no qApp, we can't flush the events
    QVERIFY(!deletedBetweenTests);
}

static bool deletedOnExit = false;

void tst_DeleteLater_noApp::qtestLibShouldNotFlushDeleteLaterOnExit()
{
    ToBeDeleted *obj = new ToBeDeleted(&deletedOnExit);
    obj->deleteLater();
}

// This global object will check whether the deleteLater was processed
class DeleteChecker
{
public:
    ~DeleteChecker() {
        if (deletedOnExit) {
            qFatal("QTestLib somehow flushed deleteLater on exit, without a qApp?");
        }
    }
};
static DeleteChecker s_deleteChecker;

QTEST_APPLESS_MAIN(tst_DeleteLater_noApp)

#include "tst_deleteLater_noApp.moc"
