//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by validation-gen. DO NOT EDIT.

package listset

import (
	context "context"
	fmt "fmt"

	equality "k8s.io/apimachinery/pkg/api/equality"
	operation "k8s.io/apimachinery/pkg/api/operation"
	safe "k8s.io/apimachinery/pkg/api/safe"
	validate "k8s.io/apimachinery/pkg/api/validate"
	field "k8s.io/apimachinery/pkg/util/validation/field"
	testscheme "k8s.io/code-generator/cmd/validation-gen/testscheme"
)

func init() { localSchemeBuilder.Register(RegisterValidations) }

// RegisterValidations adds validation functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterValidations(scheme *testscheme.Scheme) error {
	scheme.AddValidationFunc((*ImmutableStruct)(nil), func(ctx context.Context, op operation.Operation, obj, oldObj interface{}) field.ErrorList {
		switch op.Request.SubresourcePath() {
		case "/":
			return Validate_ImmutableStruct(ctx, op, nil /* fldPath */, obj.(*ImmutableStruct), safe.Cast[*ImmutableStruct](oldObj))
		}
		return field.ErrorList{field.InternalError(nil, fmt.Errorf("no validation found for %T, subresource: %v", obj, op.Request.SubresourcePath()))}
	})
	scheme.AddValidationFunc((*Struct)(nil), func(ctx context.Context, op operation.Operation, obj, oldObj interface{}) field.ErrorList {
		switch op.Request.SubresourcePath() {
		case "/":
			return Validate_Struct(ctx, op, nil /* fldPath */, obj.(*Struct), safe.Cast[*Struct](oldObj))
		}
		return field.ErrorList{field.InternalError(nil, fmt.Errorf("no validation found for %T, subresource: %v", obj, op.Request.SubresourcePath()))}
	})
	return nil
}

func Validate_ImmutableStruct(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *ImmutableStruct) (errs field.ErrorList) {
	// field ImmutableStruct.TypeMeta has no validation

	// field ImmutableStruct.SliceComparableField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []ComparableStruct) (errs field.ErrorList) {
			if op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil // no changes
			}
			errs = append(errs, validate.EachSliceVal(ctx, op, fldPath, obj, oldObj, nil, nil, validate.ImmutableByCompare)...)
			return
		}(fldPath.Child("sliceComparableField"), obj.SliceComparableField, safe.Field(oldObj, func(oldObj *ImmutableStruct) []ComparableStruct { return oldObj.SliceComparableField }))...)

	// field ImmutableStruct.SliceSetComparableField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []ComparableStruct) (errs field.ErrorList) {
			if op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil // no changes
			}
			errs = append(errs, validate.EachSliceVal(ctx, op, fldPath, obj, oldObj, validate.DirectEqual, nil, validate.ImmutableByCompare)...)
			errs = append(errs, validate.Unique(ctx, op, fldPath, obj, oldObj, validate.DirectEqual)...)
			return
		}(fldPath.Child("sliceSetComparableField"), obj.SliceSetComparableField, safe.Field(oldObj, func(oldObj *ImmutableStruct) []ComparableStruct { return oldObj.SliceSetComparableField }))...)

	// field ImmutableStruct.SliceNonComparableField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []NonComparableStruct) (errs field.ErrorList) {
			if op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil // no changes
			}
			errs = append(errs, validate.EachSliceVal(ctx, op, fldPath, obj, oldObj, nil, nil, validate.ImmutableByReflect)...)
			return
		}(fldPath.Child("sliceNonComparableField"), obj.SliceNonComparableField, safe.Field(oldObj, func(oldObj *ImmutableStruct) []NonComparableStruct { return oldObj.SliceNonComparableField }))...)

	// field ImmutableStruct.SliceSetNonComparableField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []NonComparableStruct) (errs field.ErrorList) {
			if op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil // no changes
			}
			errs = append(errs, validate.EachSliceVal(ctx, op, fldPath, obj, oldObj, validate.SemanticDeepEqual, nil, validate.ImmutableByReflect)...)
			errs = append(errs, validate.Unique(ctx, op, fldPath, obj, oldObj, validate.SemanticDeepEqual)...)
			return
		}(fldPath.Child("sliceSetNonComparableField"), obj.SliceSetNonComparableField, safe.Field(oldObj, func(oldObj *ImmutableStruct) []NonComparableStruct { return oldObj.SliceSetNonComparableField }))...)

	// field ImmutableStruct.SlicePrimitiveField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []int) (errs field.ErrorList) {
			if op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil // no changes
			}
			errs = append(errs, validate.EachSliceVal(ctx, op, fldPath, obj, oldObj, nil, nil, validate.ImmutableByCompare)...)
			return
		}(fldPath.Child("slicePrimitiveField"), obj.SlicePrimitiveField, safe.Field(oldObj, func(oldObj *ImmutableStruct) []int { return oldObj.SlicePrimitiveField }))...)

	// field ImmutableStruct.SliceSetPrimitiveField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []int) (errs field.ErrorList) {
			if op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil // no changes
			}
			errs = append(errs, validate.EachSliceVal(ctx, op, fldPath, obj, oldObj, validate.DirectEqual, nil, validate.ImmutableByCompare)...)
			errs = append(errs, validate.Unique(ctx, op, fldPath, obj, oldObj, validate.DirectEqual)...)
			return
		}(fldPath.Child("sliceSetPrimitiveField"), obj.SliceSetPrimitiveField, safe.Field(oldObj, func(oldObj *ImmutableStruct) []int { return oldObj.SliceSetPrimitiveField }))...)

	// field ImmutableStruct.SliceSetFalselyComparableField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []FalselyComparableStruct) (errs field.ErrorList) {
			if op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil // no changes
			}
			errs = append(errs, validate.EachSliceVal(ctx, op, fldPath, obj, oldObj, validate.SemanticDeepEqual, nil, validate.ImmutableByReflect)...)
			errs = append(errs, validate.Unique(ctx, op, fldPath, obj, oldObj, validate.SemanticDeepEqual)...)
			return
		}(fldPath.Child("sliceSetFalselyComparableField"), obj.SliceSetFalselyComparableField, safe.Field(oldObj, func(oldObj *ImmutableStruct) []FalselyComparableStruct { return oldObj.SliceSetFalselyComparableField }))...)

	return errs
}

func Validate_Struct(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *Struct) (errs field.ErrorList) {
	// field Struct.TypeMeta has no validation

	// field Struct.SliceStringField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []string) (errs field.ErrorList) {
			if op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil // no changes
			}
			errs = append(errs, validate.Unique(ctx, op, fldPath, obj, oldObj, validate.DirectEqual)...)
			return
		}(fldPath.Child("sliceStringField"), obj.SliceStringField, safe.Field(oldObj, func(oldObj *Struct) []string { return oldObj.SliceStringField }))...)

	// field Struct.SliceIntField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []int) (errs field.ErrorList) {
			if op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil // no changes
			}
			errs = append(errs, validate.Unique(ctx, op, fldPath, obj, oldObj, validate.DirectEqual)...)
			return
		}(fldPath.Child("sliceIntField"), obj.SliceIntField, safe.Field(oldObj, func(oldObj *Struct) []int { return oldObj.SliceIntField }))...)

	// field Struct.SliceComparableField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []ComparableStruct) (errs field.ErrorList) {
			if op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil // no changes
			}
			errs = append(errs, validate.Unique(ctx, op, fldPath, obj, oldObj, validate.DirectEqual)...)
			return
		}(fldPath.Child("sliceComparableField"), obj.SliceComparableField, safe.Field(oldObj, func(oldObj *Struct) []ComparableStruct { return oldObj.SliceComparableField }))...)

	// field Struct.SliceNonComparableField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []NonComparableStruct) (errs field.ErrorList) {
			if op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil // no changes
			}
			errs = append(errs, validate.Unique(ctx, op, fldPath, obj, oldObj, validate.SemanticDeepEqual)...)
			return
		}(fldPath.Child("sliceNonComparableField"), obj.SliceNonComparableField, safe.Field(oldObj, func(oldObj *Struct) []NonComparableStruct { return oldObj.SliceNonComparableField }))...)

	// field Struct.SliceFalselyComparableField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []FalselyComparableStruct) (errs field.ErrorList) {
			if op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil // no changes
			}
			errs = append(errs, validate.Unique(ctx, op, fldPath, obj, oldObj, validate.SemanticDeepEqual)...)
			return
		}(fldPath.Child("sliceFalselyComparableField"), obj.SliceFalselyComparableField, safe.Field(oldObj, func(oldObj *Struct) []FalselyComparableStruct { return oldObj.SliceFalselyComparableField }))...)

	return errs
}
