/*
 * Decompiled with CFR 0.152.
 */
package scala.cli.config.internal;

import java.io.Serializable;
import java.nio.file.Path;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.cli.commands.SpecificationLevel$IMPLEMENTATION$;
import scala.cli.config.ConfigDb;
import scala.cli.config.ConfigDb$;
import scala.cli.config.Key;
import scala.cli.config.Key$BooleanEntry$;
import scala.cli.config.Key$PasswordEntry$;
import scala.cli.config.Key$StringEntry$;
import scala.cli.config.Key$StringListEntry$;
import scala.cli.config.PasswordOption;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class JavaHelper$ {
    public static final JavaHelper$ MODULE$ = new JavaHelper$();
    private static Option<ConfigDb> dbOpt = Option$.MODULE$.empty();

    private Option<ConfigDb> dbOpt() {
        return dbOpt;
    }

    private void dbOpt_$eq(Option<ConfigDb> x$1) {
        dbOpt = x$1;
    }

    public void open(Path dbPath) {
        if (this.dbOpt().isEmpty()) {
            Either<Exception, ConfigDb> either = ConfigDb$.MODULE$.open(dbPath);
            if (either instanceof Left) {
                Left left = (Left)either;
                Exception ex = (Exception)left.value();
                throw new Exception(ex);
            }
            if (!(either instanceof Right)) {
                throw new MatchError(either);
            }
            Right right = (Right)either;
            ConfigDb db1 = (ConfigDb)right.value();
            ConfigDb db0 = db1;
            this.dbOpt_$eq(new Some<ConfigDb>(db0));
            return;
        }
    }

    public void close() {
        if (this.dbOpt().nonEmpty()) {
            this.dbOpt_$eq(None$.MODULE$);
            return;
        }
    }

    private Tuple2<Seq<String>, String> split(String key2) {
        String[] elems = key2.split("\\.");
        return new Tuple2<Seq<String>, String>(ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.init$extension(Predef$.MODULE$.refArrayOps(elems)))), (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps(elems)));
    }

    public String getString(String key2) {
        Option option;
        ConfigDb db = (ConfigDb)this.dbOpt().getOrElse((Function0<Nothing$> & Serializable)() -> package$.MODULE$.error("DB not open"));
        Tuple2<Seq<String>, String> tuple2 = this.split(key2);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq<String> prefix = tuple2._1();
        String name = tuple2._2();
        Tuple2<Seq<String>, String> tuple22 = new Tuple2<Seq<String>, String>(prefix, name);
        Seq<String> prefix2 = tuple22._1();
        String name2 = tuple22._2();
        Key.StringEntry key0 = new Key.StringEntry(prefix2, name2, SpecificationLevel$IMPLEMENTATION$.MODULE$, Key$StringEntry$.MODULE$.$lessinit$greater$default$4(), Key$StringEntry$.MODULE$.$lessinit$greater$default$5());
        boolean bl = false;
        Right right = null;
        Either<ConfigDb.ConfigDbFormatError, Option<String>> either = db.get(key0);
        if (either instanceof Left) {
            Left left = (Left)either;
            ConfigDb.ConfigDbFormatError ex = (ConfigDb.ConfigDbFormatError)left.value();
            throw new Exception(ex);
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                return null;
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            Some some = (Some)option;
            String str = (String)some.value();
            return str;
        }
        throw new MatchError(either);
    }

    public Boolean getBoolean(String key2) {
        Option option;
        ConfigDb db = (ConfigDb)this.dbOpt().getOrElse((Function0<Nothing$> & Serializable)() -> package$.MODULE$.error("DB not open"));
        Tuple2<Seq<String>, String> tuple2 = this.split(key2);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq<String> prefix = tuple2._1();
        String name = tuple2._2();
        Tuple2<Seq<String>, String> tuple22 = new Tuple2<Seq<String>, String>(prefix, name);
        Seq<String> prefix2 = tuple22._1();
        String name2 = tuple22._2();
        Key.BooleanEntry key0 = new Key.BooleanEntry(prefix2, name2, SpecificationLevel$IMPLEMENTATION$.MODULE$, Key$BooleanEntry$.MODULE$.$lessinit$greater$default$4(), Key$BooleanEntry$.MODULE$.$lessinit$greater$default$5());
        boolean bl = false;
        Right right = null;
        Either<ConfigDb.ConfigDbFormatError, Option<Object>> either = db.get(key0);
        if (either instanceof Left) {
            Left left = (Left)either;
            ConfigDb.ConfigDbFormatError ex = (ConfigDb.ConfigDbFormatError)left.value();
            throw new Exception(ex);
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                return null;
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            Some some = (Some)option;
            boolean value = BoxesRunTime.unboxToBoolean(some.value());
            return Predef$.MODULE$.boolean2Boolean(value);
        }
        throw new MatchError(either);
    }

    public String[] getStringList(String key2) {
        Option option;
        ConfigDb db = (ConfigDb)this.dbOpt().getOrElse((Function0<Nothing$> & Serializable)() -> package$.MODULE$.error("DB not open"));
        Tuple2<Seq<String>, String> tuple2 = this.split(key2);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq<String> prefix = tuple2._1();
        String name = tuple2._2();
        Tuple2<Seq<String>, String> tuple22 = new Tuple2<Seq<String>, String>(prefix, name);
        Seq<String> prefix2 = tuple22._1();
        String name2 = tuple22._2();
        Key.StringListEntry key0 = new Key.StringListEntry(prefix2, name2, SpecificationLevel$IMPLEMENTATION$.MODULE$, Key$StringListEntry$.MODULE$.$lessinit$greater$default$4(), Key$StringListEntry$.MODULE$.$lessinit$greater$default$5());
        boolean bl = false;
        Right right = null;
        Either<ConfigDb.ConfigDbFormatError, Option<List<String>>> either = db.get(key0);
        if (either instanceof Left) {
            Left left = (Left)either;
            ConfigDb.ConfigDbFormatError ex = (ConfigDb.ConfigDbFormatError)left.value();
            throw new Exception(ex);
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                return null;
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            Some some = (Some)option;
            List value = (List)some.value();
            return (String[])value.toArray(ClassTag$.MODULE$.apply(String.class));
        }
        throw new MatchError(either);
    }

    public String getPassword(String key2) {
        Option option;
        ConfigDb db = (ConfigDb)this.dbOpt().getOrElse((Function0<Nothing$> & Serializable)() -> package$.MODULE$.error("DB not open"));
        Tuple2<Seq<String>, String> tuple2 = this.split(key2);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq<String> prefix = tuple2._1();
        String name = tuple2._2();
        Tuple2<Seq<String>, String> tuple22 = new Tuple2<Seq<String>, String>(prefix, name);
        Seq<String> prefix2 = tuple22._1();
        String name2 = tuple22._2();
        Key.PasswordEntry key0 = new Key.PasswordEntry(prefix2, name2, SpecificationLevel$IMPLEMENTATION$.MODULE$, Key$PasswordEntry$.MODULE$.$lessinit$greater$default$4(), Key$PasswordEntry$.MODULE$.$lessinit$greater$default$5());
        boolean bl = false;
        Right right = null;
        Either<ConfigDb.ConfigDbFormatError, Option<PasswordOption>> either = db.get(key0);
        if (either instanceof Left) {
            Left left = (Left)either;
            ConfigDb.ConfigDbFormatError ex = (ConfigDb.ConfigDbFormatError)left.value();
            throw new Exception(ex);
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                return null;
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            Some some = (Some)option;
            PasswordOption str = (PasswordOption)some.value();
            return str.get().value();
        }
        throw new MatchError(either);
    }

    public byte[] getPasswordBytes(String key2) {
        Option option;
        ConfigDb db = (ConfigDb)this.dbOpt().getOrElse((Function0<Nothing$> & Serializable)() -> package$.MODULE$.error("DB not open"));
        Tuple2<Seq<String>, String> tuple2 = this.split(key2);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq<String> prefix = tuple2._1();
        String name = tuple2._2();
        Tuple2<Seq<String>, String> tuple22 = new Tuple2<Seq<String>, String>(prefix, name);
        Seq<String> prefix2 = tuple22._1();
        String name2 = tuple22._2();
        Key.PasswordEntry key0 = new Key.PasswordEntry(prefix2, name2, SpecificationLevel$IMPLEMENTATION$.MODULE$, Key$PasswordEntry$.MODULE$.$lessinit$greater$default$4(), Key$PasswordEntry$.MODULE$.$lessinit$greater$default$5());
        boolean bl = false;
        Right right = null;
        Either<ConfigDb.ConfigDbFormatError, Option<PasswordOption>> either = db.get(key0);
        if (either instanceof Left) {
            Left left = (Left)either;
            ConfigDb.ConfigDbFormatError ex = (ConfigDb.ConfigDbFormatError)left.value();
            throw new Exception(ex);
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                return null;
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            Some some = (Some)option;
            PasswordOption str = (PasswordOption)some.value();
            return str.getBytes().value();
        }
        throw new MatchError(either);
    }

    private JavaHelper$() {
    }
}

