/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.shortestpath;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.alg.shortestpath.AbstractPathElement;
import org.jgrapht.alg.shortestpath.AbstractPathElementList;
import org.jgrapht.alg.shortestpath.PathValidator;
import org.jgrapht.alg.shortestpath.RankingPathElement;
import org.jgrapht.graph.GraphWalk;
import org.jgrapht.graph.MaskSubgraph;

final class RankingPathElementList<V, E>
extends AbstractPathElementList<V, E, RankingPathElement<V, E>> {
    private V guardVertexToNotDisconnect = null;
    private Map<RankingPathElement<V, E>, Boolean> path2disconnect = new HashMap<RankingPathElement<V, E>, Boolean>();
    private PathValidator<V, E> externalPathValidator = null;

    RankingPathElementList(Graph<V, E> graph, int maxSize, RankingPathElement<V, E> pathElement) {
        this((Graph<RankingPathElement<V, E>, E>)graph, maxSize, pathElement, (PathValidator<RankingPathElement<V, E>, E>)null);
    }

    RankingPathElementList(Graph<V, E> graph, int maxSize, RankingPathElement<V, E> pathElement, PathValidator<V, E> pathValidator) {
        super(graph, maxSize, pathElement);
        this.externalPathValidator = pathValidator;
    }

    RankingPathElementList(Graph<V, E> graph, int maxSize, RankingPathElementList<V, E> elementList, E edge) {
        this(graph, maxSize, elementList, edge, null);
        assert (!this.pathElements.isEmpty());
    }

    RankingPathElementList(Graph<V, E> graph, int maxSize, RankingPathElementList<V, E> elementList, E edge, V guardVertexToNotDisconnect) {
        this(graph, maxSize, elementList, edge, guardVertexToNotDisconnect, null);
    }

    RankingPathElementList(Graph<V, E> graph, int maxSize, RankingPathElementList<V, E> elementList, E edge, V guardVertexToNotDisconnect, PathValidator<V, E> pathValidator) {
        super(graph, maxSize, elementList, edge);
        this.guardVertexToNotDisconnect = guardVertexToNotDisconnect;
        this.externalPathValidator = pathValidator;
        for (int i = 0; i < elementList.size() && this.size() < maxSize; ++i) {
            RankingPathElement prevPathElement = (RankingPathElement)elementList.get(i);
            if (this.isNotValidPath(prevPathElement, edge)) continue;
            double weight = this.calculatePathWeight(prevPathElement, edge);
            RankingPathElement newPathElement = new RankingPathElement(this.graph, prevPathElement, edge, weight);
            this.pathElements.add(newPathElement);
        }
    }

    RankingPathElementList(Graph<V, E> graph, int maxSize, V vertex) {
        this(graph, maxSize, vertex, null);
    }

    RankingPathElementList(Graph<V, E> graph, int maxSize, V vertex, PathValidator<V, E> pathValidator) {
        super(graph, maxSize, vertex);
        this.externalPathValidator = pathValidator;
    }

    public boolean addPathElements(RankingPathElementList<V, E> elementList, E edge) {
        assert (this.vertex.equals(Graphs.getOppositeVertex(this.graph, edge, elementList.getVertex())));
        boolean pathAdded = false;
        int yIndex = 0;
        for (int vIndex = 0; vIndex < elementList.size(); ++vIndex) {
            RankingPathElement prevPathElement = (RankingPathElement)elementList.get(vIndex);
            if (this.isNotValidPath(prevPathElement, edge)) continue;
            double newPathWeight = this.calculatePathWeight(prevPathElement, edge);
            RankingPathElement newPathElement = new RankingPathElement(this.graph, prevPathElement, edge, newPathWeight);
            RankingPathElement yPathElement = null;
            while (yIndex < this.size()) {
                yPathElement = (RankingPathElement)this.get(yIndex);
                if (newPathWeight < yPathElement.getWeight()) {
                    this.pathElements.add(yIndex, newPathElement);
                    pathAdded = true;
                    if (this.size() <= this.maxSize) break;
                    this.pathElements.remove(this.maxSize);
                    break;
                }
                if (newPathWeight == yPathElement.getWeight()) {
                    this.pathElements.add(yIndex + 1, newPathElement);
                    pathAdded = true;
                    if (this.size() <= this.maxSize) break;
                    this.pathElements.remove(this.maxSize);
                    break;
                }
                ++yIndex;
            }
            if (!(newPathWeight > yPathElement.getWeight())) continue;
            if (this.size() >= this.maxSize) break;
            this.pathElements.add(newPathElement);
            pathAdded = true;
        }
        return pathAdded;
    }

    List<RankingPathElement<V, E>> getPathElements() {
        return this.pathElements;
    }

    private double calculatePathWeight(RankingPathElement<V, E> pathElement, E edge) {
        double pathWeight = this.graph.getEdgeWeight(edge);
        if (pathElement.getPrevEdge() != null) {
            pathWeight += pathElement.getWeight();
        }
        return pathWeight;
    }

    private boolean isGuardVertexDisconnected(RankingPathElement<V, E> prevPathElement) {
        if (this.guardVertexToNotDisconnect == null) {
            return false;
        }
        if (this.path2disconnect.containsKey(prevPathElement)) {
            return this.path2disconnect.get(prevPathElement);
        }
        PathMask<V, E> connectivityMask = new PathMask<V, E>(prevPathElement);
        MaskSubgraph<Object, Object> connectivityGraph = new MaskSubgraph<Object, Object>(this.graph, connectivityMask::isVertexMasked, connectivityMask::isEdgeMasked);
        ConnectivityInspector<Object, Object> connectivityInspector = new ConnectivityInspector<Object, Object>(connectivityGraph);
        if (connectivityMask.isVertexMasked(this.guardVertexToNotDisconnect)) {
            this.path2disconnect.put(prevPathElement, true);
            return true;
        }
        if (!connectivityInspector.pathExists(this.vertex, this.guardVertexToNotDisconnect)) {
            this.path2disconnect.put(prevPathElement, true);
            return true;
        }
        this.path2disconnect.put(prevPathElement, false);
        return false;
    }

    private boolean isNotValidPath(RankingPathElement<V, E> prevPathElement, E edge) {
        if (!this.isSimplePath(prevPathElement, edge)) {
            return true;
        }
        if (this.isGuardVertexDisconnected(prevPathElement)) {
            return true;
        }
        if (this.externalPathValidator != null) {
            GraphWalk prevPath;
            if (prevPathElement.getPrevEdge() == null) {
                prevPath = new GraphWalk(this.graph, Collections.singletonList(prevPathElement.getVertex()), prevPathElement.getWeight());
            } else {
                List prevEdges = prevPathElement.createEdgeListPath();
                prevPath = new GraphWalk(this.graph, this.graph.getEdgeSource(prevEdges.get(0)), prevPathElement.getVertex(), prevEdges, prevPathElement.getWeight());
            }
            if (!this.externalPathValidator.isValidPath(prevPath, edge)) {
                return true;
            }
        }
        return false;
    }

    private boolean isSimplePath(RankingPathElement<V, E> prevPathElement, E edge) {
        Object endVertex = Graphs.getOppositeVertex(this.graph, edge, prevPathElement.getVertex());
        assert (endVertex.equals(this.vertex));
        AbstractPathElement pathElementToTest = prevPathElement;
        do {
            if (!pathElementToTest.getVertex().equals(endVertex)) continue;
            return false;
        } while ((pathElementToTest = pathElementToTest.getPrevPathElement()) != null);
        return true;
    }

    private static class PathMask<V, E> {
        private Set<E> maskedEdges = new HashSet();
        private Set<V> maskedVertices = new HashSet<V>();

        PathMask(RankingPathElement<V, E> pathElement) {
            while (pathElement.getPrevEdge() != null) {
                this.maskedEdges.add(pathElement.getPrevEdge());
                this.maskedVertices.add(pathElement.getVertex());
                pathElement = pathElement.getPrevPathElement();
            }
            this.maskedVertices.add(pathElement.getVertex());
        }

        public boolean isEdgeMasked(E edge) {
            return this.maskedEdges.contains(edge);
        }

        public boolean isVertexMasked(V vertex) {
            return this.maskedVertices.contains(vertex);
        }
    }
}

