/*
 * Decompiled with CFR 0.152.
 */
package mill.codesig;

import java.io.Serializable;
import mill.codesig.CallGraphAnalysis;
import mill.codesig.ExternalSummary;
import mill.codesig.JvmModel;
import mill.codesig.LocalSummary;
import mill.codesig.ResolvedCalls;
import mill.moduledefs.Scaladoc;
import mill.util.SpanningForest$;
import mill.util.Tarjans$;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcII$sp;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArraySeq;
import scala.math.Ordering$Int$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import ujson.Obj;
import upickle.core.Types;
import upickle.default$;

public final class CallGraphAnalysis$ {
    public static final CallGraphAnalysis$ MODULE$ = new CallGraphAnalysis$();

    @Scaladoc(value="/**\n   * Computes the minimal spanning forest of the that covers the nodes in the\n   * call graph whose transitive call graph hashes has changed since the last\n   * run, rendered as a JSON dictionary tree. This provides a great \"debug\n   * view\" that lets you easily Cmd-F to find a particular node and then trace\n   * it up the JSON hierarchy to figure out what upstream node was the root\n   * cause of the change in the callgraph.\n   *\n   * There are typically multiple possible spanning forests for a given graph;\n   * one is chosen arbitrarily. This is usually fine, since when debugging you\n   * typically are investigating why there's a path to a node at all where none\n   * should exist, rather than trying to fully analyse all possible paths\n   */")
    public Obj spanningInvalidationTree(Map<String, Object> prevTransitiveCallGraphHashes, Tuple2<CallGraphAnalysis.Node, Object>[] transitiveCallGraphHashes0, CallGraphAnalysis.Node[] indexToNodes, int[][] indexGraphEdges) {
        Map transitiveCallGraphHashes0Map = Predef$.MODULE$.wrapRefArray((Object[])transitiveCallGraphHashes0).toMap($less$colon$less$.MODULE$.refl());
        Set<Object> nodesWithChangedHashes = ((IterableOnceOps)ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.refArrayOps((Object[])indexGraphEdges)).filter(nodeIndex -> {
            int currentValue = BoxesRunTime.unboxToInt(transitiveCallGraphHashes0Map.apply(indexToNodes[nodeIndex]));
            Option prevValue = prevTransitiveCallGraphHashes.get(indexToNodes[nodeIndex].toString());
            return !prevValue.contains(BoxesRunTime.boxToInteger(currentValue));
        })).toSet();
        Map reverseGraphMap = ArrayOps$.MODULE$.groupMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps(ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])indexGraphEdges))), (Function1<Tuple2, Tuple2[]> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int[] vs = (int[])tuple2._1();
                int k = tuple2._2$mcI$sp();
                return (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(vs), (Function1<Object, Tuple2> & Serializable)x$8 -> CallGraphAnalysis$.$anonfun$spanningInvalidationTree$3(k, BoxesRunTime.unboxToInt(x$8)), ClassTag$.MODULE$.apply(Tuple2.class));
            }
            throw new MatchError(tuple2);
        }, (Function1<Tuple2[], ArraySeq.ofRef> & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(Tuple2.class))), (Function1<Tuple2, Object> & Serializable)x$9 -> BoxesRunTime.boxToInteger(x$9._1$mcI$sp()), (Function1<Tuple2, Object> & Serializable)x$10 -> BoxesRunTime.boxToInteger(x$10._2$mcI$sp()), ClassTag$.MODULE$.Int());
        int[][] reverseGraphEdges = (int[][])ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.refArrayOps((Object[])indexGraphEdges)).map((Function1<Object, int[]> & Serializable)x$11 -> CallGraphAnalysis$.$anonfun$spanningInvalidationTree$7(reverseGraphMap, BoxesRunTime.unboxToInt(x$11))).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
        return SpanningForest$.MODULE$.spanningTreeToJsonTree(SpanningForest$.MODULE$.apply(reverseGraphEdges, nodesWithChangedHashes, false), (Function1<Object, String> & Serializable)k -> CallGraphAnalysis$.$anonfun$spanningInvalidationTree$9(indexToNodes, BoxesRunTime.unboxToInt(k)));
    }

    public int[][] indexGraphEdges(CallGraphAnalysis.Node[] indexToNodes, Map<JvmModel.MethodDef, LocalSummary.MethodInfo> methods2, ResolvedCalls resolved, ExternalSummary externalSummary, Map<CallGraphAnalysis.Node, Object> nodeToIndex, Function2<Option<JvmModel.MethodDef>, JvmModel.MethodSig, Object> ignoreCall, JvmModel.SymbolTable st) {
        return (int[][])ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps(indexToNodes)).map((Function1<CallGraphAnalysis.Node, int[]> & Serializable)x0$1 -> {
            CallGraphAnalysis.Node node = x0$1;
            if (node instanceof CallGraphAnalysis.Call) {
                CallGraphAnalysis.Call call2 = (CallGraphAnalysis.Call)node;
                JvmModel.MethodCall methodCall = call2.call();
                ResolvedCalls.MethodCallInfo callInfo = (ResolvedCalls.MethodCallInfo)resolved.localCalls().apply(methodCall);
                int[] local = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])callInfo.localDests().toArray(ClassTag$.MODULE$.apply(JvmModel.MethodDef.class))), (Function1<JvmModel.MethodDef, Object> & Serializable)methodDef -> BoxesRunTime.boxToBoolean(CallGraphAnalysis$.$anonfun$indexGraphEdges$3(resolved, methodDef)))), (Function1<JvmModel.MethodDef, Object> & Serializable)d -> BoxesRunTime.boxToInteger(CallGraphAnalysis$.$anonfun$indexGraphEdges$4(nodeToIndex, d)), ClassTag$.MODULE$.Int());
                int[] external = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])callInfo.externalDests().toArray(ClassTag$.MODULE$.apply(JvmModel.JType.Cls.class))), (Function1<JvmModel.JType.Cls, Object> & Serializable)c -> BoxesRunTime.boxToInteger(CallGraphAnalysis$.$anonfun$indexGraphEdges$5(nodeToIndex, c)), ClassTag$.MODULE$.Int());
                return (int[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.intArrayOps(local), external, ClassTag$.MODULE$.Int());
            }
            if (node instanceof CallGraphAnalysis.LocalDef) {
                CallGraphAnalysis.LocalDef localDef = (CallGraphAnalysis.LocalDef)node;
                JvmModel.MethodDef methodDef2 = localDef.call();
                int[] normalCalls = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])((LocalSummary.MethodInfo)methods2.apply(methodDef2)).calls().toArray(ClassTag$.MODULE$.apply(JvmModel.MethodCall.class))), (Function1<JvmModel.MethodCall, Object> & Serializable)c -> BoxesRunTime.boxToBoolean(CallGraphAnalysis$.$anonfun$indexGraphEdges$6(ignoreCall, methodDef2, st, c)))), (Function1<JvmModel.MethodCall, Object> & Serializable)c -> BoxesRunTime.boxToInteger(CallGraphAnalysis$.$anonfun$indexGraphEdges$7(nodeToIndex, c)), ClassTag$.MODULE$.Int());
                String string = methodDef2.sig().name();
                String string2 = "<init>";
                None$ singleAbstractMethodInitEdge = (string == null ? string2 != null : !string.equals(string2)) ? None$.MODULE$ : CallGraphAnalysis$.singleAbstractMethods$1(methodDef2.cls(), resolved).flatMap((Function1<JvmModel.MethodSig, Option> & Serializable)samSig -> nodeToIndex.get(new CallGraphAnalysis.LocalDef(st.MethodDef().apply(methodDef2.cls(), (JvmModel.MethodSig)samSig))));
                return (int[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.intArrayOps(normalCalls), singleAbstractMethodInitEdge, ClassTag$.MODULE$.Int());
            }
            if (node instanceof CallGraphAnalysis.ExternalClsCall) {
                CallGraphAnalysis.ExternalClsCall externalClsCall = (CallGraphAnalysis.ExternalClsCall)node;
                JvmModel.JType.Cls externalCls = externalClsCall.call();
                int[] local = (int[])resolved.externalClassLocalDests().get(externalCls).iterator().flatMap((Function1<Tuple2, Set> & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        Set localClasses = (Set)tuple2._1();
                        Set localMethods = (Set)tuple2._2();
                        if (localClasses != null) {
                            Set set = localClasses;
                            if (localMethods != null) {
                                Set set2 = localMethods;
                                return (Set)set.flatMap((Function1<JvmModel.JType.Cls, Set> & Serializable)cls -> (Set)set2.withFilter((Function1<JvmModel.MethodSig, Object> & Serializable)m -> BoxesRunTime.boxToBoolean(methods2.contains(st.MethodDef().apply(cls, m)))).withFilter((Function1<JvmModel.MethodSig, Object> & Serializable)m -> BoxesRunTime.boxToBoolean(CallGraphAnalysis$.$anonfun$indexGraphEdges$12(cls, resolved, m))).withFilter((Function1<JvmModel.MethodSig, Object> & Serializable)m -> BoxesRunTime.boxToBoolean(CallGraphAnalysis$.$anonfun$indexGraphEdges$13(ignoreCall, m))).map((Function1<JvmModel.MethodSig, Object> & Serializable)m -> BoxesRunTime.boxToInteger(CallGraphAnalysis$.$anonfun$indexGraphEdges$14(nodeToIndex, st, cls, m))));
                            }
                        }
                    }
                    throw new MatchError(tuple2);
                }).toArray(ClassTag$.MODULE$.Int());
                Set parent = (Set)((IterableOps)externalSummary.directAncestors().apply(externalCls)).map((Function1<JvmModel.JType.Cls, Object> & Serializable)c -> BoxesRunTime.boxToInteger(CallGraphAnalysis$.$anonfun$indexGraphEdges$15(nodeToIndex, c)));
                return (int[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.intArrayOps(local), parent, ClassTag$.MODULE$.Int());
            }
            throw new MatchError(node);
        }).map((Function1<int[], int[]> & Serializable)x$12 -> (int[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.intArrayOps((int[])x$12), Ordering$Int$.MODULE$)).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
    }

    @Scaladoc(value="/**\n   * Summarizes the transitive closure of the given graph, using the given\n   * [[computeOutputValue]] and [[reduce]] functions to return a single value of [[T]].\n   *\n   * This is done in topological order, in order to allow us to memo-ize the\n   * values computed for upstream groups when processing downstream methods,\n   * avoiding the need to repeatedly re-compute them. Each Strongly Connected\n   * Component is processed together and assigned the same final value, since\n   * they all have the exact same transitive closure\n   */")
    public <V> Tuple2<CallGraphAnalysis.Node, V>[] transitiveCallGraphValues(int[][] indexGraphEdges, CallGraphAnalysis.Node[] indexToNodes, Object nodeValues, Function2<V, V, V> reduce, V zero, ClassTag<V> evidence$2) {
        int[][] topoSortedMethodGroups = Tarjans$.MODULE$.apply(indexGraphEdges);
        Map nodeGroups = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])topoSortedMethodGroups)).zipWithIndex().flatMap((Function1<Tuple2, ArraySeq.ofRef> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int[] group2 = (int[])tuple2._1();
                int groupIndex = tuple2._2$mcI$sp();
                return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(group2), (Function1<Object, Tuple2> & Serializable)x$13 -> CallGraphAnalysis$.$anonfun$transitiveCallGraphValues$2(groupIndex, BoxesRunTime.unboxToInt(x$13)), ClassTag$.MODULE$.apply(Tuple2.class)));
            }
            throw new MatchError(tuple2);
        }).toMap($less$colon$less$.MODULE$.refl());
        Object seenGroupValues = evidence$2.newArray(topoSortedMethodGroups.length);
        ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.refArrayOps((Object[])topoSortedMethodGroups)).foreach$mVc$sp(groupIndex -> {
            ObjectRef<Object> value = ObjectRef.create(zero);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(topoSortedMethodGroups[groupIndex]), node -> {
                value$1.elem = reduce.apply(value$1.elem, ScalaRunTime$.MODULE$.array_apply(nodeValues, node));
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(indexGraphEdges[node]), upstreamNode -> {
                    int upstreamGroup = BoxesRunTime.unboxToInt(nodeGroups.apply(BoxesRunTime.boxToInteger(upstreamNode)));
                    if (upstreamGroup != groupIndex) {
                        value$1.elem = reduce.apply(value$1.elem, ScalaRunTime$.MODULE$.array_apply(seenGroupValues, upstreamGroup));
                        return;
                    }
                });
            });
            ScalaRunTime$.MODULE$.array_update(seenGroupValues, groupIndex, value.elem);
        });
        return (Tuple2[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps(ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.genericArrayOps(seenGroupValues))), (Function1<Tuple2, Tuple2[]> & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Object groupHash = tuple2._1();
                int groupIndex = tuple2._2$mcI$sp();
                return (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(topoSortedMethodGroups[groupIndex]), (Function1<Object, Tuple2> & Serializable)nodeIndex -> CallGraphAnalysis$.$anonfun$transitiveCallGraphValues$7(indexToNodes, groupHash, BoxesRunTime.unboxToInt(nodeIndex)), ClassTag$.MODULE$.apply(Tuple2.class));
            }
            throw new MatchError(tuple2);
        }, (Function1<Tuple2[], ArraySeq.ofRef> & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Types.Writer<CallGraphAnalysis.Node> nodeRw() {
        return default$.MODULE$.stringKeyW(default$.MODULE$.writer(default$.MODULE$.StringWriter()).comap((Function1<CallGraphAnalysis.Node, String> & Serializable)x$14 -> x$14.toString()));
    }

    public static final /* synthetic */ Tuple2 $anonfun$spanningInvalidationTree$3(int k$2, int x$8) {
        return new Tuple2$mcII$sp(x$8, k$2);
    }

    public static final /* synthetic */ int[] $anonfun$spanningInvalidationTree$7(Map reverseGraphMap$1, int x$11) {
        return (int[])reverseGraphMap$1.getOrElse(BoxesRunTime.boxToInteger(x$11), (Function0<int[]> & Serializable)() -> (int[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.Int()));
    }

    public static final /* synthetic */ String $anonfun$spanningInvalidationTree$9(CallGraphAnalysis.Node[] indexToNodes$1, int k) {
        return indexToNodes$1[k].toString();
    }

    private static final Set singleAbstractMethods$1(JvmModel.JType.Cls methodDefCls, ResolvedCalls resolved$1) {
        return (Set)resolved$1.classSingleAbstractMethods().getOrElse(methodDefCls, (Function0<Set> & Serializable)() -> Predef$.MODULE$.Set().empty());
    }

    public static final /* synthetic */ boolean $anonfun$indexGraphEdges$3(ResolvedCalls resolved$1, JvmModel.MethodDef methodDef) {
        return !CallGraphAnalysis$.singleAbstractMethods$1(methodDef.cls(), resolved$1).contains(methodDef.sig());
    }

    public static final /* synthetic */ int $anonfun$indexGraphEdges$4(Map nodeToIndex$1, JvmModel.MethodDef d) {
        return BoxesRunTime.unboxToInt(nodeToIndex$1.apply(new CallGraphAnalysis.LocalDef(d)));
    }

    public static final /* synthetic */ int $anonfun$indexGraphEdges$5(Map nodeToIndex$1, JvmModel.JType.Cls c) {
        return BoxesRunTime.unboxToInt(nodeToIndex$1.apply(new CallGraphAnalysis.ExternalClsCall(c)));
    }

    public static final /* synthetic */ boolean $anonfun$indexGraphEdges$6(Function2 ignoreCall$1, JvmModel.MethodDef methodDef$1, JvmModel.SymbolTable st$1, JvmModel.MethodCall c) {
        return !BoxesRunTime.unboxToBoolean(ignoreCall$1.apply(new Some<JvmModel.MethodDef>(methodDef$1), c.toMethodSig(st$1)));
    }

    public static final /* synthetic */ int $anonfun$indexGraphEdges$7(Map nodeToIndex$1, JvmModel.MethodCall c) {
        return BoxesRunTime.unboxToInt(nodeToIndex$1.apply(new CallGraphAnalysis.Call(c)));
    }

    public static final /* synthetic */ boolean $anonfun$indexGraphEdges$12(JvmModel.JType.Cls cls$1, ResolvedCalls resolved$1, JvmModel.MethodSig m) {
        return !CallGraphAnalysis$.singleAbstractMethods$1(cls$1, resolved$1).contains(m);
    }

    public static final /* synthetic */ boolean $anonfun$indexGraphEdges$13(Function2 ignoreCall$1, JvmModel.MethodSig m) {
        return !BoxesRunTime.unboxToBoolean(ignoreCall$1.apply(None$.MODULE$, m));
    }

    public static final /* synthetic */ int $anonfun$indexGraphEdges$14(Map nodeToIndex$1, JvmModel.SymbolTable st$1, JvmModel.JType.Cls cls$1, JvmModel.MethodSig m) {
        return BoxesRunTime.unboxToInt(nodeToIndex$1.apply(new CallGraphAnalysis.LocalDef(st$1.MethodDef().apply(cls$1, m))));
    }

    public static final /* synthetic */ int $anonfun$indexGraphEdges$15(Map nodeToIndex$1, JvmModel.JType.Cls c) {
        return BoxesRunTime.unboxToInt(nodeToIndex$1.apply(new CallGraphAnalysis.ExternalClsCall(c)));
    }

    public static final /* synthetic */ Tuple2 $anonfun$transitiveCallGraphValues$2(int groupIndex$1, int x$13) {
        return new Tuple2$mcII$sp(x$13, groupIndex$1);
    }

    public static final /* synthetic */ Tuple2 $anonfun$transitiveCallGraphValues$7(CallGraphAnalysis.Node[] indexToNodes$2, Object groupHash$1, int nodeIndex) {
        return new Tuple2<CallGraphAnalysis.Node, Object>(indexToNodes$2[nodeIndex], groupHash$1);
    }

    private CallGraphAnalysis$() {
    }
}

