/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import org.jspecify.annotations.Nullable;

public abstract class ComparableSubject<T extends Comparable<?>>
extends Subject {
    private final @Nullable T actual;

    protected ComparableSubject(FailureMetadata metadata, @Nullable T actual) {
        super(metadata, actual);
        this.actual = actual;
    }

    public final void isIn(Range<T> range) {
        if (!range.contains((Comparable)Preconditions.checkNotNull(this.actual))) {
            this.failWithActual("expected to be in range", range);
        }
    }

    public final void isNotIn(Range<T> range) {
        if (range.contains((Comparable)Preconditions.checkNotNull(this.actual))) {
            this.failWithActual("expected not to be in range", range);
        }
    }

    public void isEquivalentAccordingToCompareTo(@Nullable T expected) {
        if (((Comparable)Preconditions.checkNotNull(this.actual)).compareTo(Preconditions.checkNotNull(expected)) != 0) {
            this.failWithActual("expected value that sorts equal to", expected);
        }
    }

    public final void isGreaterThan(@Nullable T other) {
        if (((Comparable)Preconditions.checkNotNull(this.actual)).compareTo(Preconditions.checkNotNull(other)) <= 0) {
            this.failWithActual("expected to be greater than", other);
        }
    }

    public final void isLessThan(@Nullable T other) {
        if (((Comparable)Preconditions.checkNotNull(this.actual)).compareTo(Preconditions.checkNotNull(other)) >= 0) {
            this.failWithActual("expected to be less than", other);
        }
    }

    public final void isAtMost(@Nullable T other) {
        if (((Comparable)Preconditions.checkNotNull(this.actual)).compareTo(Preconditions.checkNotNull(other)) > 0) {
            this.failWithActual("expected to be at most", other);
        }
    }

    public final void isAtLeast(@Nullable T other) {
        if (((Comparable)Preconditions.checkNotNull(this.actual)).compareTo(Preconditions.checkNotNull(other)) < 0) {
            this.failWithActual("expected to be at least", other);
        }
    }
}

