/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.primitive;

import java.util.Objects;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.primitive.AbstractIntegerMorpher;

public final class LongMorpher
extends AbstractIntegerMorpher {
    private long defaultValue;

    public LongMorpher() {
    }

    public LongMorpher(long defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LongMorpher)) {
            return false;
        }
        LongMorpher other = (LongMorpher)obj;
        if (this.isUseDefault() && other.isUseDefault()) {
            return Objects.equals(this.getDefaultValue(), other.getDefaultValue());
        }
        return !this.isUseDefault() && !other.isUseDefault();
    }

    public long getDefaultValue() {
        return this.defaultValue;
    }

    public int hashCode() {
        if (this.isUseDefault()) {
            return Objects.hashCode(this.getDefaultValue());
        }
        return 17;
    }

    public long morph(Object value) {
        if (value == null) {
            if (this.isUseDefault()) {
                return this.defaultValue;
            }
            throw new MorphException("value is null");
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        long i = 0L;
        try {
            i = Long.parseLong(this.getIntegerValue(value));
            return i;
        }
        catch (NumberFormatException nfe) {
            if (this.isUseDefault()) {
                return this.defaultValue;
            }
            throw new MorphException(nfe);
        }
    }

    @Override
    public Class morphsTo() {
        return Long.TYPE;
    }
}

