/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.bean;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.MorphUtils;
import net.sf.ezmorph.MorpherRegistry;
import net.sf.ezmorph.bean.MorphDynaBean;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;

public final class MorphDynaClass
implements DynaClass,
Serializable {
    private static final Comparator dynaPropertyComparator = new Comparator(){

        public int compare(Object a, Object b) {
            if (a instanceof DynaProperty && b instanceof DynaProperty) {
                DynaProperty p1 = (DynaProperty)a;
                DynaProperty p2 = (DynaProperty)b;
                return p1.getName().compareTo(p2.getName());
            }
            return -1;
        }
    };
    private static final long serialVersionUID = -613214016860871560L;
    private Map attributes;
    private Class beanClass;
    private DynaProperty[] dynaProperties;
    private String name;
    private Map properties = new HashMap();
    private Class type;

    public MorphDynaClass(Map attributes) {
        this(null, null, attributes);
    }

    public MorphDynaClass(Map attributes, boolean exceptionOnEmptyAttributes) {
        this(null, null, attributes, exceptionOnEmptyAttributes);
    }

    public MorphDynaClass(String name, Class type, Map attributes) {
        this(name, type, attributes, false);
    }

    public MorphDynaClass(String name, Class type, Map attributes, boolean exceptionOnEmptyAttributes) {
        if (name == null) {
            name = "MorphDynaClass";
        }
        if (type == null) {
            type = MorphDynaBean.class;
        }
        if (!MorphDynaBean.class.isAssignableFrom(type)) {
            throw new MorphException("MorphDynaBean is not assignable from " + type.getName());
        }
        if (attributes == null || attributes.isEmpty()) {
            if (exceptionOnEmptyAttributes) {
                throw new MorphException("Attributes map is null or empty.");
            }
            attributes = new HashMap();
        }
        this.name = name;
        this.type = type;
        this.attributes = attributes;
        this.process();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MorphDynaClass)) {
            return false;
        }
        MorphDynaClass other = (MorphDynaClass)obj;
        if (!Objects.equals(this.name, other.name) || !Objects.equals(this.type, other.type)) {
            return false;
        }
        if (this.dynaProperties.length != other.dynaProperties.length) {
            return false;
        }
        for (int i = 0; i < this.dynaProperties.length; ++i) {
            DynaProperty a = this.dynaProperties[i];
            DynaProperty b = other.dynaProperties[i];
            if (Objects.equals(a.getName(), b.getName()) && Objects.equals(a.getType(), b.getType())) continue;
            return false;
        }
        return true;
    }

    public DynaProperty[] getDynaProperties() {
        return this.dynaProperties;
    }

    public DynaProperty getDynaProperty(String propertyName) {
        if (propertyName == null) {
            throw new MorphException("Unnespecified bean property name");
        }
        return (DynaProperty)this.properties.get(propertyName);
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int result = Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.type);
        for (DynaProperty dynaProperty : this.dynaProperties) {
            result = 31 * result + Objects.hashCode(dynaProperty.getName());
            result = 31 * result + Objects.hashCode(dynaProperty.getType());
        }
        return result;
    }

    public DynaBean newInstance() throws IllegalAccessException, InstantiationException {
        return this.newInstance(null);
    }

    public DynaBean newInstance(MorpherRegistry morpherRegistry) throws IllegalAccessException, InstantiationException {
        if (morpherRegistry == null) {
            morpherRegistry = new MorpherRegistry();
            MorphUtils.registerStandardMorphers(morpherRegistry);
        }
        MorphDynaBean dynaBean = (MorphDynaBean)this.getBeanClass().newInstance();
        dynaBean.setDynaBeanClass(this);
        dynaBean.setMorpherRegistry(morpherRegistry);
        for (Object o : this.attributes.keySet()) {
            String key = (String)o;
            dynaBean.set(key, null);
        }
        return dynaBean;
    }

    public String toString() {
        return String.format("%s[name=%s, type=%s, attributes=%s]", this.getClass().getSimpleName(), this.name, this.type, this.attributes);
    }

    protected Class getBeanClass() {
        if (this.beanClass == null) {
            this.process();
        }
        return this.beanClass;
    }

    private void process() {
        this.beanClass = this.type;
        try {
            Iterator entries = this.attributes.entrySet().iterator();
            this.dynaProperties = new DynaProperty[this.attributes.size()];
            int i = 0;
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                String pname = (String)entry.getKey();
                Object pclass = entry.getValue();
                DynaProperty dynaProperty = null;
                if (pclass instanceof String) {
                    klass = Class.forName((String)pclass);
                    if (klass.isArray() && klass.getComponentType().isArray()) {
                        throw new MorphException("Multidimensional arrays are not supported");
                    }
                    dynaProperty = new DynaProperty(pname, klass);
                } else if (pclass instanceof Class) {
                    klass = (Class)pclass;
                    if (klass.isArray() && klass.getComponentType().isArray()) {
                        throw new MorphException("Multidimensional arrays are not supported");
                    }
                    dynaProperty = new DynaProperty(pname, klass);
                } else {
                    throw new MorphException("Type must be String or Class");
                }
                this.properties.put(dynaProperty.getName(), dynaProperty);
                this.dynaProperties[i++] = dynaProperty;
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new MorphException(cnfe);
        }
        Arrays.sort(this.dynaProperties, 0, this.dynaProperties.length, dynaPropertyComparator);
    }
}

