/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.util;

import hudson.remoting.Channel;
import hudson.remoting.Command;
import hudson.remoting.Request;
import hudson.remoting.Response;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingChannelListener
extends Channel.Listener {
    private final Logger logger;
    private final Level level;

    public LoggingChannelListener(Logger logger, Level level) {
        this.logger = logger;
        this.level = level;
    }

    @Override
    public void onClosed(Channel channel, IOException cause) {
        if (this.logger.isLoggable(this.level)) {
            this.logger.log(this.level, null, cause);
        }
    }

    @Override
    public void onRead(Channel channel, Command cmd, long blockSize) {
        if (this.logger.isLoggable(this.level)) {
            this.logger.log(this.level, channel.getName() + " read " + blockSize + ": " + String.valueOf(cmd));
        }
    }

    @Override
    public void onWrite(Channel channel, Command cmd, long blockSize) {
        if (this.logger.isLoggable(this.level)) {
            this.logger.log(this.level, channel.getName() + " wrote " + blockSize + ": " + String.valueOf(cmd));
        }
    }

    @Override
    public void onResponse(Channel channel, Request<?, ?> req, Response<?, ?> rsp, long totalTime) {
        if (this.logger.isLoggable(this.level)) {
            this.logger.log(this.level, channel.getName() + " received response in " + totalTime / 1000000L + "ms: " + String.valueOf(req));
        }
    }

    @Override
    public void onJar(Channel channel, File jar) {
        if (this.logger.isLoggable(this.level)) {
            this.logger.log(this.level, channel.getName() + " sending " + String.valueOf(jar) + " of length " + jar.length());
        }
    }
}

