/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.Enumeration;
import java.util.jar.Manifest;
import org.jenkinsci.remoting.util.PathUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class Util {
    static String getBaseName(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    static byte[] readFully(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Util.copy(in, baos);
        return baos.toByteArray();
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        try (InputStream inputStream = in;){
            int len;
            byte[] buf = new byte[8192];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
    }

    @NonNull
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="This path exists within a temp directory so the potential traversal is limited.")
    static File makeResource(String name, byte[] image) throws IOException {
        Path tmpDir = Files.createTempDirectory("resource-", new FileAttribute[0]);
        File resource = new File(tmpDir.toFile(), name);
        Files.createDirectories(PathUtils.fileToPath(resource.getParentFile()), new FileAttribute[0]);
        Files.createFile(PathUtils.fileToPath(resource), new FileAttribute[0]);
        try (FileOutputStream fos = new FileOutputStream(resource);){
            fos.write(image);
        }
        Util.deleteDirectoryOnExit(tmpDir.toFile());
        return resource;
    }

    static void deleteDirectoryOnExit(File dir) {
        File[] childFiles;
        dir.deleteOnExit();
        if (dir.isDirectory() && (childFiles = dir.listFiles()) != null) {
            for (File f : childFiles) {
                Util.deleteDirectoryOnExit(f);
            }
        }
    }

    static String indent(String s) {
        return "    " + s.trim().replace("\n", "\n    ");
    }

    public static String getVersion() {
        String version = "unknown";
        try {
            Enumeration<URL> resEnum = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resEnum.hasMoreElements()) {
                URL url = resEnum.nextElement();
                InputStream is = url.openStream();
                try {
                    Manifest manifest;
                    if (is == null || (version = (manifest = new Manifest(is)).getMainAttributes().getValue("Version")) == null) continue;
                    break;
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (IOException e) {
            System.out.println("Could not access manifest");
        }
        return version;
    }

    public static boolean shouldBailOut(@NonNull Instant firstAttempt, @CheckForNull Duration noReconnectAfter) {
        if (noReconnectAfter == null) {
            return false;
        }
        return Duration.between(firstAttempt, Instant.now()).compareTo(noReconnectAfter) > 0;
    }

    private Util() {
    }
}

