/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.annotation_indexer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hudson.annotation_indexer.SubtypeIterator;

public class Index {
    private static final List<String> PREFIXES = Arrays.asList("META-INF/annotations/", "META-INF/services/annotations/");
    private static final Logger LOGGER = Logger.getLogger(Index.class.getName());

    public static <T extends AnnotatedElement> Iterable<T> list(Class<? extends Annotation> type, ClassLoader cl, final Class<T> subType) throws IOException {
        final Iterable<AnnotatedElement> base = Index.list(type, cl);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new SubtypeIterator(base.iterator(), subType);
            }
        };
    }

    public static Set<String> listClassNames(Class<? extends Annotation> type, ClassLoader cl) throws IOException {
        TreeSet<String> ids = new TreeSet<String>();
        for (String prefix : PREFIXES) {
            Enumeration<URL> res = cl.getResources(prefix + type.getName());
            while (res.hasMoreElements()) {
                URL url = res.nextElement();
                InputStream is = url.openStream();
                try (BufferedReader r = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                    String line;
                    while ((line = r.readLine()) != null) {
                        ids.add(line);
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        return ids;
    }

    public static Iterable<AnnotatedElement> list(final Class<? extends Annotation> type, final ClassLoader cl) throws IOException {
        final Set<String> ids = Index.listClassNames(type, cl);
        return new Iterable<AnnotatedElement>(){

            @Override
            public Iterator<AnnotatedElement> iterator() {
                return new Iterator<AnnotatedElement>(){
                    private AnnotatedElement next;
                    private final Iterator<String> iditr;
                    private final List<AnnotatedElement> lookaheads;
                    {
                        this.iditr = ids.iterator();
                        this.lookaheads = new LinkedList<AnnotatedElement>();
                    }

                    @Override
                    public boolean hasNext() {
                        this.fetch();
                        return this.next != null;
                    }

                    @Override
                    public AnnotatedElement next() {
                        this.fetch();
                        AnnotatedElement r = this.next;
                        this.next = null;
                        return r;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    private void fetch() {
                        while (this.next == null) {
                            if (!this.lookaheads.isEmpty()) {
                                this.next = this.lookaheads.remove(0);
                                return;
                            }
                            if (!this.iditr.hasNext()) {
                                return;
                            }
                            String name = this.iditr.next();
                            try {
                                Class<?> c;
                                if (name.endsWith(".*")) {
                                    Package p = Package.getPackage(name.substring(0, name.length() - 2));
                                    this.lookaheads.add(p);
                                }
                                if ((c = cl.loadClass(name)).isAnnotationPresent(type)) {
                                    this.lookaheads.add(c);
                                }
                                this.listAnnotatedElements(c.getDeclaredMethods());
                                this.listAnnotatedElements(c.getDeclaredFields());
                                this.listAnnotatedElements(c.getDeclaredConstructors());
                            }
                            catch (ClassNotFoundException | NoClassDefFoundError x) {
                                LOGGER.log(Level.FINE, "Failed to load: " + name, x);
                            }
                            catch (LinkageError | RuntimeException x) {
                                LOGGER.log(Level.WARNING, "Failed to load " + name, x);
                            }
                        }
                    }

                    private void listAnnotatedElements(AnnotatedElement[] elements) {
                        for (AnnotatedElement m : elements) {
                            if (!m.isAnnotationPresent(type)) continue;
                            this.lookaheads.add(m);
                        }
                    }
                };
            }
        };
    }

    private Index() {
    }
}

