/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.glassfish.tyrus.core;

import io.jenkins.cli.shaded.jakarta.websocket.CloseReason;
import io.jenkins.cli.shaded.jakarta.websocket.EncodeException;
import io.jenkins.cli.shaded.jakarta.websocket.RemoteEndpoint;
import io.jenkins.cli.shaded.jakarta.websocket.SendHandler;
import io.jenkins.cli.shaded.jakarta.websocket.SendResult;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.DebugContext;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.OutputStreamToAsyncBinaryAdapter;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.TyrusEndpointWrapper;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.TyrusSession;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.TyrusWebSocket;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.Utils;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.WriterToAsyncTextAdapter;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.frame.Frame;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.l10n.LocalizationMessages;
import io.jenkins.cli.shaded.org.glassfish.tyrus.spi.WriterInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TyrusRemoteEndpoint
implements RemoteEndpoint {
    final TyrusSession session;
    final TyrusWebSocket webSocket;
    private final TyrusEndpointWrapper endpointWrapper;
    private static final Logger LOGGER = Logger.getLogger(TyrusRemoteEndpoint.class.getName());

    private TyrusRemoteEndpoint(TyrusSession session, TyrusWebSocket socket, TyrusEndpointWrapper endpointWrapper) {
        this.webSocket = socket;
        this.endpointWrapper = endpointWrapper;
        this.session = session;
    }

    Future<?> sendSyncObject(Object o, WriterInfo writerInfo) {
        Object toSend;
        try {
            this.session.getDebugContext().appendLogMessage(LOGGER, Level.FINEST, DebugContext.Type.MESSAGE_OUT, "Sending object: ", o);
            toSend = this.endpointWrapper.doEncode(this.session, o);
        }
        catch (Exception e) {
            return new Future<Object>(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return false;
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public boolean isDone() {
                    return true;
                }

                @Override
                public Object get() throws InterruptedException, ExecutionException {
                    throw new ExecutionException(e);
                }

                @Override
                public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    throw new ExecutionException(e);
                }
            };
        }
        if (toSend instanceof String) {
            return this.webSocket.sendText((String)toSend, writerInfo);
        }
        if (toSend instanceof ByteBuffer) {
            return this.webSocket.sendBinary(Utils.getRemainingArray((ByteBuffer)toSend), writerInfo);
        }
        if (toSend instanceof StringWriter) {
            StringWriter writer = (StringWriter)toSend;
            StringBuffer sb = writer.getBuffer();
            return this.webSocket.sendText(sb.toString(), writerInfo);
        }
        if (toSend instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)toSend;
            return this.webSocket.sendBinary(baos.toByteArray(), writerInfo);
        }
        return null;
    }

    void sendSyncObject(Object o, SendHandler handler, WriterInfo writerInfo) {
        if (o instanceof String) {
            this.webSocket.sendText((String)o, handler, writerInfo);
        } else {
            Object toSend = null;
            try {
                toSend = this.endpointWrapper.doEncode(this.session, o);
            }
            catch (Exception e) {
                handler.onResult(new SendResult(e));
            }
            if (toSend instanceof String) {
                this.webSocket.sendText((String)toSend, handler, writerInfo);
            } else if (toSend instanceof ByteBuffer) {
                this.webSocket.sendBinary(Utils.getRemainingArray((ByteBuffer)toSend), handler, writerInfo);
            } else if (toSend instanceof StringWriter) {
                StringWriter writer = (StringWriter)toSend;
                StringBuffer sb = writer.getBuffer();
                this.webSocket.sendText(sb.toString(), handler, writerInfo);
            } else if (toSend instanceof ByteArrayOutputStream) {
                ByteArrayOutputStream baos = (ByteArrayOutputStream)toSend;
                this.webSocket.sendBinary(baos.toByteArray(), handler, writerInfo);
            }
        }
    }

    @Override
    public void sendPing(ByteBuffer applicationData) throws IOException {
        if (applicationData != null && applicationData.remaining() > 125) {
            throw new IllegalArgumentException(LocalizationMessages.APPLICATION_DATA_TOO_LONG("Ping"));
        }
        this.session.restartIdleTimeoutExecutor();
        this.webSocket.sendPing(Utils.getRemainingArray(applicationData));
    }

    @Override
    public void sendPong(ByteBuffer applicationData) throws IOException {
        if (applicationData != null && applicationData.remaining() > 125) {
            throw new IllegalArgumentException(LocalizationMessages.APPLICATION_DATA_TOO_LONG("Pong"));
        }
        this.session.restartIdleTimeoutExecutor();
        this.webSocket.sendPong(Utils.getRemainingArray(applicationData));
    }

    public String toString() {
        return "Wrapped: " + this.getClass().getSimpleName();
    }

    @Override
    public void setBatchingAllowed(boolean allowed) {
    }

    @Override
    public boolean getBatchingAllowed() {
        return false;
    }

    @Override
    public void flushBatch() {
    }

    public void close(CloseReason cr) {
        LOGGER.fine("Close public void close(CloseReason cr): " + String.valueOf(cr));
        this.webSocket.close(cr);
    }

    static class Async
    extends TyrusRemoteEndpoint
    implements RemoteEndpoint.Async {
        private long sendTimeout;

        Async(TyrusSession session, TyrusWebSocket socket, TyrusEndpointWrapper endpointWrapper) {
            super(session, socket, endpointWrapper);
            if (session.getContainer() != null) {
                this.setSendTimeout(session.getContainer().getDefaultAsyncSendTimeout());
            }
        }

        @Override
        public void sendText(String text, SendHandler handler) {
            Utils.checkNotNull(text, "text");
            Utils.checkNotNull(handler, "handler");
            this.session.restartIdleTimeoutExecutor();
            this.sendAsync(text, handler, AsyncMessageType.TEXT);
        }

        @Override
        public Future<Void> sendText(String text) {
            Utils.checkNotNull(text, "text");
            this.session.restartIdleTimeoutExecutor();
            return this.sendAsync(text, AsyncMessageType.TEXT);
        }

        @Override
        public Future<Void> sendBinary(ByteBuffer data) {
            Utils.checkNotNull(data, "data");
            this.session.restartIdleTimeoutExecutor();
            return this.sendAsync(data, AsyncMessageType.BINARY);
        }

        @Override
        public void sendBinary(ByteBuffer data, SendHandler handler) {
            Utils.checkNotNull(data, "data");
            Utils.checkNotNull(handler, "handler");
            this.session.restartIdleTimeoutExecutor();
            this.sendAsync(data, handler, AsyncMessageType.BINARY);
        }

        @Override
        public void sendObject(Object data, SendHandler handler) {
            Utils.checkNotNull(data, "data");
            Utils.checkNotNull(handler, "handler");
            this.session.restartIdleTimeoutExecutor();
            this.sendAsync(data, handler, AsyncMessageType.OBJECT);
        }

        @Override
        public Future<Void> sendObject(Object data) {
            Utils.checkNotNull(data, "data");
            this.session.restartIdleTimeoutExecutor();
            return this.sendAsync(data, AsyncMessageType.OBJECT);
        }

        @Override
        public long getSendTimeout() {
            return this.sendTimeout;
        }

        @Override
        public void setSendTimeout(long timeoutmillis) {
            this.sendTimeout = timeoutmillis;
            this.webSocket.setWriteTimeout(timeoutmillis);
        }

        private Future<Void> sendAsync(Object message, AsyncMessageType type) {
            Future<Object> result = null;
            switch (type.ordinal()) {
                case 0: {
                    this.session.getDebugContext().appendLogMessage(LOGGER, Level.FINEST, DebugContext.Type.MESSAGE_OUT, "Sending text message: ", message);
                    result = this.webSocket.sendText((String)message, new WriterInfo(WriterInfo.MessageType.TEXT, WriterInfo.RemoteEndpointType.ASYNC));
                    break;
                }
                case 1: {
                    this.session.getDebugContext().appendLogMessage(LOGGER, Level.FINEST, DebugContext.Type.MESSAGE_OUT, "Sending binary message");
                    result = this.webSocket.sendBinary(Utils.getRemainingArray((ByteBuffer)message), new WriterInfo(WriterInfo.MessageType.BINARY, WriterInfo.RemoteEndpointType.ASYNC));
                    break;
                }
                case 2: {
                    result = this.sendSyncObject(message, new WriterInfo(WriterInfo.MessageType.OBJECT, WriterInfo.RemoteEndpointType.ASYNC));
                }
            }
            final Future<?> finalResult = result;
            return new Future<Void>(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return finalResult.cancel(mayInterruptIfRunning);
                }

                @Override
                public boolean isCancelled() {
                    return finalResult.isCancelled();
                }

                @Override
                public boolean isDone() {
                    return finalResult.isDone();
                }

                @Override
                public Void get() throws InterruptedException, ExecutionException {
                    finalResult.get();
                    return null;
                }

                @Override
                public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    finalResult.get(timeout, unit);
                    return null;
                }
            };
        }

        private void sendAsync(Object message, SendHandler handler, AsyncMessageType type) {
            switch (type.ordinal()) {
                case 0: {
                    this.webSocket.sendText((String)message, handler, new WriterInfo(WriterInfo.MessageType.TEXT, WriterInfo.RemoteEndpointType.ASYNC));
                    break;
                }
                case 1: {
                    this.webSocket.sendBinary(Utils.getRemainingArray((ByteBuffer)message), handler, new WriterInfo(WriterInfo.MessageType.BINARY, WriterInfo.RemoteEndpointType.ASYNC));
                    break;
                }
                case 2: {
                    this.sendSyncObject(message, handler, new WriterInfo(WriterInfo.MessageType.OBJECT, WriterInfo.RemoteEndpointType.ASYNC));
                }
            }
        }

        private static enum AsyncMessageType {
            TEXT,
            BINARY,
            OBJECT;

        }
    }

    static class Basic
    extends TyrusRemoteEndpoint
    implements RemoteEndpoint.Basic {
        Basic(TyrusSession session, TyrusWebSocket socket, TyrusEndpointWrapper endpointWrapper) {
            super(session, socket, endpointWrapper);
        }

        @Override
        public void sendText(String text) throws IOException {
            Utils.checkNotNull(text, "text");
            this.session.getDebugContext().appendLogMessage(LOGGER, Level.FINEST, DebugContext.Type.MESSAGE_OUT, "Sending text message: ", text);
            Future<Frame> future = this.webSocket.sendText(text, new WriterInfo(WriterInfo.MessageType.TEXT, WriterInfo.RemoteEndpointType.BASIC));
            try {
                this.processFuture(future);
            }
            finally {
                this.session.restartIdleTimeoutExecutor();
            }
        }

        @Override
        public void sendBinary(ByteBuffer data) throws IOException {
            Utils.checkNotNull(data, "data");
            this.session.getDebugContext().appendLogMessage(LOGGER, Level.FINEST, DebugContext.Type.MESSAGE_OUT, "Sending binary message");
            Future<Frame> future = this.webSocket.sendBinary(Utils.getRemainingArray(data), new WriterInfo(WriterInfo.MessageType.BINARY, WriterInfo.RemoteEndpointType.BASIC));
            try {
                this.processFuture(future);
            }
            finally {
                this.session.restartIdleTimeoutExecutor();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendText(String partialMessage, boolean isLast) throws IOException {
            Utils.checkNotNull(partialMessage, "partialMessage");
            this.session.getDebugContext().appendLogMessage(LOGGER, Level.FINEST, DebugContext.Type.MESSAGE_OUT, "Sending partial text message: ", partialMessage);
            Future<Frame> future = this.webSocket.sendText(partialMessage, isLast, new WriterInfo(isLast ? WriterInfo.MessageType.TEXT : WriterInfo.MessageType.TEXT_CONTINUATION, WriterInfo.RemoteEndpointType.BASIC));
            try {
                this.processFuture(future);
            }
            finally {
                this.session.restartIdleTimeoutExecutor();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendBinary(ByteBuffer partialByte, boolean isLast) throws IOException {
            Utils.checkNotNull(partialByte, "partialByte");
            this.session.getDebugContext().appendLogMessage(LOGGER, Level.FINEST, DebugContext.Type.MESSAGE_OUT, "Sending partial binary message");
            Future<Frame> future = this.webSocket.sendBinary(Utils.getRemainingArray(partialByte), isLast, new WriterInfo(isLast ? WriterInfo.MessageType.BINARY : WriterInfo.MessageType.BINARY_CONTINUATION, WriterInfo.RemoteEndpointType.BASIC));
            try {
                this.processFuture(future);
            }
            finally {
                this.session.restartIdleTimeoutExecutor();
            }
        }

        private void processFuture(Future<?> future) throws IOException {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new IOException(e.getCause());
            }
        }

        @Override
        public void sendObject(Object data) throws IOException, EncodeException {
            Utils.checkNotNull(data, "data");
            Future<?> future = this.sendSyncObject(data, new WriterInfo(WriterInfo.MessageType.OBJECT, WriterInfo.RemoteEndpointType.BASIC));
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                if (e.getCause() instanceof EncodeException) {
                    throw (EncodeException)e.getCause();
                }
                throw new IOException(e.getCause());
            }
            this.session.restartIdleTimeoutExecutor();
        }

        @Override
        public OutputStream getSendStream() throws IOException {
            return new OutputStreamToAsyncBinaryAdapter(this.webSocket);
        }

        @Override
        public Writer getSendWriter() throws IOException {
            return new WriterToAsyncTextAdapter(this.webSocket);
        }
    }
}

