/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.glassfish.tyrus.core;

import io.jenkins.cli.shaded.jakarta.websocket.WebSocketContainer;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.ExecutorServiceProvider;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.VirtualThreadUtil;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.collection.LazyValue;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.collection.Values;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.virtual.LoomishExecutors;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseContainer
extends ExecutorServiceProvider
implements WebSocketContainer {
    private static final Logger LOGGER = Logger.getLogger(BaseContainer.class.getName());
    private final ExecutorService managedExecutorService;
    private final ScheduledExecutorService managedScheduledExecutorService;
    private final ThreadFactory threadFactory;
    private final Object EXECUTORS_CLEAN_UP_LOCK = new Object();
    private volatile ExecutorService executorService = null;
    private volatile ScheduledExecutorService scheduledExecutorService = null;

    public BaseContainer() {
        this.managedExecutorService = BaseContainer.lookupManagedExecutorService();
        this.managedScheduledExecutorService = BaseContainer.lookupManagedScheduledExecutorService();
        this.threadFactory = this.managedExecutorService == null || this.managedScheduledExecutorService == null ? new DaemonThreadFactory(this::getProperties) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutorService getExecutorService() {
        if (this.managedExecutorService != null) {
            return this.managedExecutorService;
        }
        if (this.executorService == null) {
            Object object = this.EXECUTORS_CLEAN_UP_LOCK;
            synchronized (object) {
                if (this.executorService == null) {
                    this.executorService = VirtualThreadUtil.withConfig(this.getProperties(), this.threadFactory, null).newCachedThreadPool();
                }
            }
        }
        return this.executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        if (this.managedScheduledExecutorService != null) {
            return this.managedScheduledExecutorService;
        }
        if (this.scheduledExecutorService == null) {
            Object object = this.EXECUTORS_CLEAN_UP_LOCK;
            synchronized (object) {
                if (this.scheduledExecutorService == null) {
                    this.scheduledExecutorService = VirtualThreadUtil.withConfig(this.getProperties(), this.threadFactory, null).getScheduledExecutorService(10);
                }
            }
        }
        return this.scheduledExecutorService;
    }

    public void shutdown() {
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
        }
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
            this.scheduledExecutorService = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown(ShutDownCondition shutDownCondition) {
        Object object = this.EXECUTORS_CLEAN_UP_LOCK;
        synchronized (object) {
            if (shutDownCondition.evaluate()) {
                this.shutdown();
            }
        }
    }

    public abstract Map<String, Object> getProperties();

    private static ExecutorService lookupManagedExecutorService() {
        try {
            Class<?> aClass = Class.forName("javax.naming.InitialContext");
            Object o = aClass.newInstance();
            Method lookupMethod = aClass.getMethod("lookup", String.class);
            return (ExecutorService)lookupMethod.invoke(o, "java:comp/DefaultManagedExecutorService");
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getMessage(), e);
            }
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        return null;
    }

    private static ScheduledExecutorService lookupManagedScheduledExecutorService() {
        try {
            Class<?> aClass = Class.forName("javax.naming.InitialContext");
            Object o = aClass.newInstance();
            Method lookupMethod = aClass.getMethod("lookup", String.class);
            return (ScheduledExecutorService)lookupMethod.invoke(o, "java:comp/DefaultManagedScheduledExecutorService");
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getMessage(), e);
            }
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        return null;
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix = "tyrus-" + poolNumber.getAndIncrement() + "-thread-";
        final LazyValue<LoomishExecutors> lazyExecutors = Values.lazy(() -> VirtualThreadUtil.withConfig((Map)mapSupplier.get(), null, null));

        DaemonThreadFactory(Supplier<Map<String, Object>> mapSupplier) {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = ((LoomishExecutors)this.lazyExecutors.get()).newThread(this.namePrefix + this.threadNumber.getAndIncrement(), r);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    protected static interface ShutDownCondition {
        public boolean evaluate();
    }
}

