/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.bouncycastle.crypto.agreement;

import io.jenkins.cli.shaded.org.bouncycastle.crypto.CipherParameters;
import io.jenkins.cli.shaded.org.bouncycastle.crypto.CryptoServicesRegistrar;
import io.jenkins.cli.shaded.org.bouncycastle.crypto.RawAgreement;
import io.jenkins.cli.shaded.org.bouncycastle.crypto.agreement.Utils;
import io.jenkins.cli.shaded.org.bouncycastle.crypto.params.X448PrivateKeyParameters;
import io.jenkins.cli.shaded.org.bouncycastle.crypto.params.X448PublicKeyParameters;

public final class X448Agreement
implements RawAgreement {
    private X448PrivateKeyParameters privateKey;

    @Override
    public void init(CipherParameters cipherParameters) {
        this.privateKey = (X448PrivateKeyParameters)cipherParameters;
        CryptoServicesRegistrar.checkConstraints(Utils.getDefaultProperties("X448", this.privateKey));
    }

    @Override
    public int getAgreementSize() {
        return 56;
    }

    @Override
    public void calculateAgreement(CipherParameters cipherParameters, byte[] byArray, int n) {
        this.privateKey.generateSecret((X448PublicKeyParameters)cipherParameters, byArray, n);
    }
}

