/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public abstract class DirectedGraph<N> {
    protected abstract Collection<N> nodes();

    protected abstract Collection<N> forward(N var1);

    public List<SCC<N>> getStronglyConnectedComponents() {
        final HashMap<N, Node> nodes = new HashMap<N, Node>();
        for (N n : this.nodes()) {
            nodes.put(n, new Node(n));
        }
        final ArrayList<SCC<N>> sccs = new ArrayList<SCC<N>>();
        class Tarjan {
            int index = 0;
            int sccIndex = 0;
            Stack<Node> pending = new Stack();

            Tarjan() {
            }

            void traverse() {
                for (Node n : nodes.values()) {
                    if (n.index != -1) continue;
                    this.visit(n);
                }
            }

            void visit(Node v) {
                v.lowlink = this.index++;
                v.index = v.lowlink;
                this.pending.push(v);
                for (Object q : v.edges()) {
                    Node w = (Node)nodes.get(q);
                    if (w.index == -1) {
                        this.visit(w);
                        v.lowlink = Math.min(v.lowlink, w.lowlink);
                        continue;
                    }
                    if (!this.pending.contains(w)) continue;
                    v.lowlink = Math.min(v.lowlink, w.index);
                }
                if (v.lowlink == v.index) {
                    Node w;
                    SCC scc = new SCC(this.sccIndex++);
                    sccs.add(scc);
                    do {
                        w = this.pending.pop();
                        w.scc = scc;
                        scc.members.add(w.n);
                    } while (w != v);
                }
            }
        }
        new Tarjan().traverse();
        Collections.reverse(sccs);
        return sccs;
    }

    class Node {
        final N n;
        int index = -1;
        int lowlink;
        @SuppressFBWarnings(value={"URF_UNREAD_FIELD"}, justification="no big deal")
        SCC scc;

        Node(N n) {
            this.n = n;
        }

        Collection<N> edges() {
            return DirectedGraph.this.forward(this.n);
        }
    }

    public static class SCC<N>
    extends AbstractSet<N> {
        public final int index;
        private final List<N> members = new ArrayList<N>();

        public SCC(int index) {
            this.index = index;
        }

        @Override
        public Iterator<N> iterator() {
            return this.members.iterator();
        }

        @Override
        public int size() {
            return this.members.size();
        }
    }
}

