/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.csp.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.csp.CspReceiver;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
@Extension
public class LoggingReceiver
implements CspReceiver {
    private static final Logger LOGGER = Logger.getLogger(LoggingReceiver.class.getName());

    @Override
    public void report(@NonNull CspReceiver.ViewContext viewContext, String userId, @NonNull JSONObject report) {
        if (userId == null) {
            LOGGER.log(Level.FINEST, "Received anonymous report for context {0}: {1}", new Object[]{viewContext, report});
        } else {
            LOGGER.log(Level.FINE, "Received report from {0} for context {1}: {2}", new Object[]{userId, viewContext, report});
        }
    }
}

