/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.csp.impl;

import hudson.Extension;
import hudson.Main;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.csp.CspHeader;
import jenkins.security.csp.CspHeaderDecider;
import jenkins.util.SystemProperties;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
@Extension(ordinal=8.988465674311579E307)
public class DevelopmentHeaderDecider
implements CspHeaderDecider {
    private static final Logger LOGGER = Logger.getLogger(DevelopmentHeaderDecider.class.getName());
    static boolean DISABLED = SystemProperties.getBoolean(DevelopmentHeaderDecider.class.getName() + ".DISABLED");

    @Override
    public Optional<CspHeader> decide() {
        if (DISABLED) {
            LOGGER.log(Level.FINEST, "DevelopmentHeaderDecider disabled by system property");
            return Optional.empty();
        }
        LOGGER.log(Level.FINEST, "Main.isUnitTest: {0}, Main.isDevelopmentMode: {1}", new Object[]{Main.isUnitTest, Main.isDevelopmentMode});
        if (Main.isUnitTest || Main.isDevelopmentMode) {
            return Optional.of(CspHeader.ContentSecurityPolicy);
        }
        return Optional.empty();
    }
}

