/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.csp;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import jenkins.security.HMACConfidentialKey;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.springframework.security.core.Authentication;

@Restricted(value={Beta.class})
public class ReportingContext {
    private static final HMACConfidentialKey KEY = new HMACConfidentialKey(ReportingContext.class, "key");

    private ReportingContext() {
    }

    private static String toBase64(String utf8) {
        return Base64.getUrlEncoder().encodeToString(utf8.getBytes(StandardCharsets.UTF_8));
    }

    private static String fromBase64(String b64) {
        return new String(Base64.getUrlDecoder().decode(b64), StandardCharsets.UTF_8);
    }

    public static String encodeContext(@CheckForNull Class<?> ancestorClass, @CheckForNull Authentication authentication, @NonNull String restOfPath) {
        String userId = authentication == null ? "" : authentication.getName();
        String encodedContext = ReportingContext.toBase64(userId) + ":" + ReportingContext.toBase64(ancestorClass == null ? "" : ancestorClass.getName()) + ":" + ReportingContext.toBase64(restOfPath);
        String mac = Base64.getUrlEncoder().encodeToString(KEY.mac(encodedContext.getBytes(StandardCharsets.UTF_8)));
        return mac + ":" + encodedContext;
    }

    public static DecodedContext decodeContext(String rawContext) {
        String[] macAndContext = rawContext.split(":", 2);
        if (macAndContext.length != 2) {
            throw new IllegalArgumentException("Unexpected number of split entries, expected 2, got " + macAndContext.length);
        }
        String mac = macAndContext[0];
        String encodedContext = macAndContext[1];
        if (!KEY.checkMac(encodedContext.getBytes(StandardCharsets.UTF_8), Base64.getUrlDecoder().decode(mac))) {
            throw new IllegalArgumentException("Mac check failed for " + encodedContext);
        }
        String[] encodedContextParts = encodedContext.split(":", 3);
        if (encodedContextParts.length != 3) {
            throw new IllegalArgumentException("Unexpected number of split entries, expected 3, got " + encodedContextParts.length);
        }
        return new DecodedContext(ReportingContext.fromBase64(encodedContextParts[0]), ReportingContext.fromBase64(encodedContextParts[1]), ReportingContext.fromBase64(encodedContextParts[2]));
    }

    public record DecodedContext(String userId, String contextClassName, String restOfPath) {
        public DecodedContext(@CheckForNull String userId, @NonNull String contextClassName, @NonNull String restOfPath) {
            this.userId = Util.fixEmpty(userId);
            this.contextClassName = contextClassName;
            this.restOfPath = restOfPath;
        }
    }
}

