/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.csp;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.ExtensionList;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.csp.Contributor;
import jenkins.security.csp.CspBuilder;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

@Restricted(value={Beta.class})
@Extension
public class AvatarContributor
implements Contributor {
    private static final Logger LOGGER = Logger.getLogger(AvatarContributor.class.getName());
    private final Set<String> domains = ConcurrentHashMap.newKeySet();

    @Override
    public void apply(CspBuilder cspBuilder) {
        this.domains.forEach(d -> cspBuilder.add("img-src", (String)d));
    }

    public static void allow(@CheckForNull String url) {
        String domain = AvatarContributor.extractDomainFromUrl(url);
        if (domain == null) {
            LOGGER.log(Level.FINE, "Skipping null domain in avatar URL: " + url);
            return;
        }
        if (ExtensionList.lookupSingleton(AvatarContributor.class).domains.add(domain)) {
            LOGGER.log(Level.CONFIG, "Adding domain '" + domain + "' from avatar URL: " + url);
        } else {
            LOGGER.log(Level.FINEST, "Skipped adding duplicate domain '" + domain + "' from avatar URL: " + url);
        }
    }

    @CheckForNull
    public static String extractDomainFromUrl(@CheckForNull String url) {
        if (url == null) {
            return null;
        }
        try {
            int port;
            URI uri = new URI(url);
            String host = uri.getHost();
            if (host == null) {
                LOGGER.log(Level.FINER, "Ignoring URI without host: " + url);
                return null;
            }
            Object domain = host.toLowerCase(Locale.ROOT);
            String scheme = uri.getScheme();
            if (scheme != null) {
                if ((scheme = scheme.toLowerCase(Locale.ROOT)).equals("http") || scheme.equals("https")) {
                    domain = scheme + "://" + (String)domain;
                } else {
                    LOGGER.log(Level.FINER, "Ignoring URI with unsupported scheme: " + url);
                    return null;
                }
            }
            if ((port = uri.getPort()) != -1) {
                domain = (String)domain + ":" + port;
            }
            return domain;
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.FINE, "Failed to parse avatar URI: " + url, e);
            return null;
        }
    }
}

