/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model.lazy;

import hudson.util.AdaptedIterator;
import hudson.util.Iterators;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.IntConsumer;
import jenkins.model.lazy.BuildReference;

class BuildReferenceMapAdapter<R>
extends AbstractMap<Integer, R>
implements SortedMap<Integer, R> {
    private final NavigableMap<Integer, BuildReference<R>> core;
    private final Resolver<R> resolver;
    private final Set<Integer> keySet = new KeySetAdapter();
    private final Collection<R> values = new ValuesAdapter();
    private final Set<Map.Entry<Integer, R>> entrySet = new EntrySetAdapter();

    BuildReferenceMapAdapter(NavigableMap<Integer, BuildReference<R>> core, Resolver<R> resolver) {
        this.core = core;
        this.resolver = resolver;
    }

    @Override
    public Comparator<? super Integer> comparator() {
        return this.core.comparator();
    }

    @Override
    public SortedMap<Integer, R> subMap(Integer fromKey, Integer toKey) {
        return new BuildReferenceMapAdapter<R>(this.core.subMap(fromKey, true, toKey, false), this.resolver);
    }

    @Override
    public SortedMap<Integer, R> headMap(Integer toKey) {
        return new BuildReferenceMapAdapter<R>(this.core.headMap(toKey, false), this.resolver);
    }

    @Override
    public SortedMap<Integer, R> tailMap(Integer fromKey) {
        return new BuildReferenceMapAdapter<R>(this.core.tailMap(fromKey, true), this.resolver);
    }

    @Override
    public Integer firstKey() {
        return (Integer)this.keySet.stream().findFirst().orElseThrow(NoSuchElementException::new);
    }

    @Override
    public Integer lastKey() {
        return new BuildReferenceMapAdapter<R>(this.core.descendingMap(), this.resolver).firstKey();
    }

    @Override
    public Set<Integer> keySet() {
        return this.keySet;
    }

    @Override
    public Collection<R> values() {
        return this.values;
    }

    @Override
    public Set<Map.Entry<Integer, R>> entrySet() {
        return this.entrySet;
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        BuildReference ref;
        BuildReference buildReference = ref = key instanceof Integer ? (BuildReference)this.core.get(key) : null;
        if (ref == null) {
            return false;
        }
        if (!ref.isSet()) {
            this.resolver.resolveBuildRef(ref);
        }
        return !ref.isUnloadable();
    }

    @Override
    public boolean containsValue(Object value) {
        if (!this.resolver.getBuildClass().isInstance(value)) {
            return false;
        }
        R val = this.resolver.getBuildClass().cast(value);
        return val.equals(this.get(this.resolver.getNumberOf(val)));
    }

    @Override
    public R get(Object key) {
        return key instanceof Integer ? (R)this.resolver.resolveBuildRef((BuildReference)this.core.get(key)) : null;
    }

    @Override
    public R remove(Object key) {
        R val = this.get(key);
        if (val == null) {
            return null;
        }
        return (R)(this.removeValue(val) ? val : null);
    }

    protected boolean removeValue(R value) {
        throw new UnsupportedOperationException();
    }

    private class KeySetAdapter
    extends AbstractSet<Integer> {
        private KeySetAdapter() {
        }

        @Override
        public int size() {
            return BuildReferenceMapAdapter.this.size();
        }

        @Override
        public boolean isEmpty() {
            return BuildReferenceMapAdapter.this.isEmpty();
        }

        @Override
        public boolean contains(Object k) {
            return BuildReferenceMapAdapter.this.containsKey(k);
        }

        @Override
        public boolean remove(Object o) {
            return BuildReferenceMapAdapter.this.remove(o) != null;
        }

        @Override
        public Iterator<Integer> iterator() {
            return new AdaptedIterator<Map.Entry<Integer, R>, Integer>(BuildReferenceMapAdapter.this.entrySet().iterator()){

                @Override
                protected Integer adapt(Map.Entry<Integer, R> e) {
                    return e.getKey();
                }
            };
        }

        @Override
        public Spliterator<Integer> spliterator() {
            return new Spliterators.AbstractIntSpliterator(Long.MAX_VALUE, 21){
                private final Iterator<Integer> it;
                {
                    this.it = KeySetAdapter.this.iterator();
                }

                @Override
                public boolean tryAdvance(IntConsumer action) {
                    Objects.requireNonNull(action);
                    if (this.it.hasNext()) {
                        action.accept(this.it.next());
                        return true;
                    }
                    return false;
                }

                @Override
                public Comparator<? super Integer> getComparator() {
                    return BuildReferenceMapAdapter.this.comparator();
                }
            };
        }
    }

    private class ValuesAdapter
    extends AbstractCollection<R> {
        private ValuesAdapter() {
        }

        @Override
        public int size() {
            return BuildReferenceMapAdapter.this.size();
        }

        @Override
        public boolean isEmpty() {
            return BuildReferenceMapAdapter.this.isEmpty();
        }

        @Override
        public boolean contains(Object v) {
            return BuildReferenceMapAdapter.this.containsValue(v);
        }

        @Override
        public boolean remove(Object o) {
            return BuildReferenceMapAdapter.this.resolver.getBuildClass().isInstance(o) && BuildReferenceMapAdapter.this.removeValue(BuildReferenceMapAdapter.this.resolver.getBuildClass().cast(o));
        }

        @Override
        public Iterator<R> iterator() {
            return new AdaptedIterator<Map.Entry<Integer, R>, R>(BuildReferenceMapAdapter.this.entrySet().iterator()){

                @Override
                protected R adapt(Map.Entry<Integer, R> e) {
                    return e.getValue();
                }
            };
        }

        @Override
        public Spliterator<R> spliterator() {
            return Spliterators.spliteratorUnknownSize(this.iterator(), 17);
        }
    }

    private class EntrySetAdapter
    extends AbstractSet<Map.Entry<Integer, R>> {
        private EntrySetAdapter() {
        }

        @Override
        public int size() {
            return BuildReferenceMapAdapter.this.core.size();
        }

        @Override
        public boolean isEmpty() {
            return this.stream().findFirst().isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            Map.Entry e;
            Object k;
            if (o instanceof Map.Entry && (k = (e = (Map.Entry)o).getKey()) instanceof Integer) {
                Integer key = (Integer)k;
                return e.getValue() != null && e.getValue().equals(BuildReferenceMapAdapter.this.get(key));
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                return BuildReferenceMapAdapter.this.resolver.getBuildClass().isInstance(e.getValue()) && BuildReferenceMapAdapter.this.removeValue(BuildReferenceMapAdapter.this.resolver.getBuildClass().cast(e.getValue()));
            }
            return false;
        }

        @Override
        public Iterator<Map.Entry<Integer, R>> iterator() {
            return new Iterator<Map.Entry<Integer, R>>(){
                private Map.Entry<Integer, R> current;
                private final Iterator<Map.Entry<Integer, R>> it;
                {
                    this.it = Iterators.removeNull(Iterators.map(BuildReferenceMapAdapter.this.core.entrySet().iterator(), coreEntry -> {
                        BuildReference ref = (BuildReference)coreEntry.getValue();
                        if (!ref.isSet()) {
                            Object r = BuildReferenceMapAdapter.this.resolver.resolveBuildRef(ref);
                            if (r == null) {
                                return null;
                            }
                            return new EntryAdapter(coreEntry, r);
                        }
                        if (ref.isUnloadable()) {
                            return null;
                        }
                        return new EntryAdapter(coreEntry);
                    }));
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public Map.Entry<Integer, R> next() {
                    this.current = this.it.next();
                    return this.current;
                }

                @Override
                public void remove() {
                    if (this.current == null) {
                        throw new IllegalStateException();
                    }
                    BuildReferenceMapAdapter.this.removeValue(this.current.getValue());
                }
            };
        }

        @Override
        public Spliterator<Map.Entry<Integer, R>> spliterator() {
            return Spliterators.spliteratorUnknownSize(this.iterator(), 17);
        }
    }

    public static interface Resolver<R> {
        public R resolveBuildRef(BuildReference<R> var1);

        public Integer getNumberOf(R var1);

        public Class<R> getBuildClass();
    }

    private class EntryAdapter
    implements Map.Entry<Integer, R> {
        private final Map.Entry<Integer, BuildReference<R>> coreEntry;
        private volatile R resolvedValue;

        EntryAdapter(Map.Entry<Integer, BuildReference<R>> coreEntry) {
            this(coreEntry, null);
        }

        EntryAdapter(Map.Entry<Integer, BuildReference<R>> coreEntry, R resolvedValue) {
            this.coreEntry = coreEntry;
            this.resolvedValue = resolvedValue;
        }

        private Map.Entry<Integer, R> getResolvedEntry() {
            return new AbstractMap.SimpleEntry(this.getKey(), this.getValue());
        }

        @Override
        public Integer getKey() {
            return this.coreEntry.getKey();
        }

        @Override
        public R getValue() {
            Object value = this.resolvedValue;
            if (value != null) {
                return value;
            }
            this.resolvedValue = BuildReferenceMapAdapter.this.resolver.resolveBuildRef(this.coreEntry.getValue());
            return this.resolvedValue;
        }

        @Override
        public R setValue(R value) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.getResolvedEntry().toString();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Map.Entry && this.getResolvedEntry().equals(o);
        }

        @Override
        public int hashCode() {
            return this.getResolvedEntry().hashCode();
        }
    }
}

