/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model.experimentalflags;

import edu.umd.cs.findbugs.annotations.NonNull;
import jenkins.model.experimentalflags.UserExperimentalFlag;
import jenkins.util.SystemProperties;

public abstract class BooleanUserExperimentalFlag
extends UserExperimentalFlag<Boolean> {
    protected BooleanUserExperimentalFlag(@NonNull String flagKey) {
        super(flagKey);
    }

    @Override
    @NonNull
    public Boolean getDefaultValue() {
        return SystemProperties.getBoolean(this.getFlagKey() + ".defaultValue");
    }

    @Override
    public Object serializeValue(Boolean rawValue) {
        if (rawValue == null) {
            return null;
        }
        return rawValue != false ? "true" : "false";
    }

    @Override
    protected Boolean deserializeValue(Object serializedValue) {
        if (serializedValue.equals("true")) {
            return Boolean.TRUE;
        }
        if (serializedValue.equals("false")) {
            return Boolean.FALSE;
        }
        return null;
    }
}

