/*
 * Decompiled with CFR 0.152.
 */
package hudson.logging;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FeedAdapter;
import hudson.Functions;
import hudson.RestrictedSince;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.logging.LogRecorder;
import hudson.logging.Messages;
import hudson.model.AbstractModelObject;
import hudson.model.Failure;
import hudson.model.RSS;
import hudson.util.CopyOnWriteMap;
import hudson.util.FormValidation;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.model.ModelObjectWithChildren;
import jenkins.model.ModelObjectWithContextMenu;
import jenkins.util.SystemProperties;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class LogRecorderManager
extends AbstractModelObject
implements ModelObjectWithChildren,
StaplerProxy {
    private static final Logger LOGGER = Logger.getLogger(LogRecorderManager.class.getName());
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.323")
    public final transient Map<String, LogRecorder> logRecorders = new CopyOnWriteMap.Tree<String, LogRecorder>();
    private List<LogRecorder> recorders = new ArrayList<LogRecorder>();
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static boolean SKIP_PERMISSION_CHECK = SystemProperties.getBoolean(LogRecorderManager.class.getName() + ".skipPermissionCheck");

    @DataBoundConstructor
    public LogRecorderManager() {
    }

    public List<LogRecorder> getRecorders() {
        return this.recorders;
    }

    @DataBoundSetter
    public void setRecorders(List<LogRecorder> recorders) {
        this.recorders = recorders;
        Map values = recorders.stream().collect(Collectors.toMap(LogRecorder::getName, Function.identity(), (recorder1, recorder2) -> {
            LOGGER.warning(String.format("Ignoring duplicate log recorder '%s', check $JENKINS_HOME/log and remove the duplicate recorder", recorder2.getName()));
            return recorder1;
        }));
        ((CopyOnWriteMap)this.logRecorders).replaceBy(values);
    }

    @Override
    public String getDisplayName() {
        return Messages.LogRecorderManager_DisplayName();
    }

    @Override
    public String getSearchUrl() {
        return "/log";
    }

    public LogRecorder getDynamic(String token) {
        return this.getLogRecorder(token);
    }

    public LogRecorder getLogRecorder(String token) {
        return this.recorders.stream().filter(logRecorder -> logRecorder.getName().equals(token)).findAny().orElse(null);
    }

    static File configDir() {
        return new File(Jenkins.get().getRootDir(), "log");
    }

    public void load() throws IOException {
        this.recorders.clear();
        File dir = LogRecorderManager.configDir();
        File[] files = dir.listFiles((FileFilter)new WildcardFileFilter("*.xml"));
        if (files == null) {
            return;
        }
        for (File child : files) {
            String name = child.getName();
            name = name.substring(0, name.length() - 4);
            LogRecorder lr = new LogRecorder(name);
            lr.load();
            this.recorders.add(lr);
        }
    }

    @RequirePOST
    public HttpResponse doNewLogRecorder(@QueryParameter String name) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        Jenkins.checkGoodName(name);
        this.recorders.add(new LogRecorder(name));
        return new HttpRedirect(name + "/configure");
    }

    @Restricted(value={NoExternalUse.class})
    public FormValidation doCheckNewName(@QueryParameter String name) {
        if (Util.fixEmpty(name) == null) {
            return FormValidation.ok();
        }
        try {
            Jenkins.checkGoodName(name);
        }
        catch (Failure e) {
            return FormValidation.error(e.getMessage());
        }
        return FormValidation.ok();
    }

    @Override
    public ModelObjectWithContextMenu.ContextMenu doChildrenContextMenu(StaplerRequest2 request, StaplerResponse2 response) throws Exception {
        ModelObjectWithContextMenu.ContextMenu menu = new ModelObjectWithContextMenu.ContextMenu();
        menu.add("all", "All Jenkins Logs");
        for (LogRecorder lr : this.recorders) {
            menu.add(lr.getSearchUrl(), lr.getDisplayName());
        }
        return menu;
    }

    @RequirePOST
    @SuppressFBWarnings(value={"LG_LOST_LOGGER_DUE_TO_WEAK_REFERENCE"}, justification="if the logger is known, then we have a reference to it in LogRecorder#loggers")
    public HttpResponse doConfigLogger(@QueryParameter String name, @QueryParameter String level) {
        Logger target;
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        Level lv = level.equals("inherit") ? null : Level.parse(level.toUpperCase(Locale.ENGLISH));
        if (Collections.list(LogManager.getLogManager().getLoggerNames()).contains(name) && (target = Logger.getLogger(name)) != null) {
            target.setLevel(lv);
            return new HttpRedirect("levels");
        }
        throw new Failure(Messages.LogRecorderManager_LoggerNotFound(name));
    }

    public void doRss(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        LogRecorderManager.doRss(req, rsp, Jenkins.logRecords);
    }

    static void doRss(StaplerRequest2 req, StaplerResponse2 rsp, List<LogRecord> logs) throws IOException, ServletException {
        String entryType = "all";
        String level = req.getParameter("level");
        if (level != null) {
            Level threshold = Level.parse(level);
            ArrayList<LogRecord> filtered = new ArrayList<LogRecord>();
            for (LogRecord r : logs) {
                if (r.getLevel().intValue() < threshold.intValue()) continue;
                filtered.add(r);
            }
            logs = filtered;
            entryType = level;
        }
        RSS.forwardToRss("Jenkins:log (" + entryType + " entries)", "", logs, new FeedAdapter<LogRecord>(){

            @Override
            public String getEntryTitle(LogRecord entry) {
                return entry.getMessage();
            }

            @Override
            public String getEntryUrl(LogRecord entry) {
                return "log";
            }

            @Override
            public String getEntryID(LogRecord entry) {
                return String.valueOf(entry.getSequenceNumber());
            }

            @Override
            public String getEntryDescription(LogRecord entry) {
                return Functions.printLogRecord(entry);
            }

            @Override
            public Calendar getEntryTimestamp(LogRecord entry) {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTimeInMillis(entry.getMillis());
                return cal;
            }

            @Override
            public String getEntryAuthor(LogRecord entry) {
                return JenkinsLocationConfiguration.get().getAdminAddress();
            }
        }, req, (HttpServletResponse)rsp);
    }

    @Initializer(before=InitMilestone.PLUGINS_PREPARED)
    public static void init(Jenkins h) throws IOException {
        h.getLog().load();
    }

    @Restricted(value={NoExternalUse.class})
    public Object getTarget() {
        if (!SKIP_PERMISSION_CHECK) {
            Jenkins.get().checkPermission(Jenkins.SYSTEM_READ);
        }
        return this;
    }
}

