/*
 * Decompiled with CFR 0.152.
 */
package hudson.lifecycle;

import com.sun.jna.Library;
import com.sun.jna.Native;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.lifecycle.ExitLifecycle;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class SystemdLifecycle
extends ExitLifecycle {
    private static final Logger LOGGER = Logger.getLogger(SystemdLifecycle.class.getName());

    @Override
    public void onReady() {
        super.onReady();
        SystemdLifecycle.notify("READY=1");
    }

    @Override
    public void onReload(@NonNull String user, @CheckForNull String remoteAddr) {
        super.onReload(user, remoteAddr);
        SystemdLifecycle.notify("RELOADING=1");
    }

    @Override
    public void onStop(@NonNull String user, @CheckForNull String remoteAddr) {
        super.onStop(user, remoteAddr);
        SystemdLifecycle.notify("STOPPING=1");
    }

    @Override
    public void onExtendTimeout(long timeout, @NonNull TimeUnit unit) {
        super.onExtendTimeout(timeout, unit);
        SystemdLifecycle.notify(String.format("EXTEND_TIMEOUT_USEC=%d", unit.toMicros(timeout)));
    }

    @Override
    public void onStatusUpdate(String status) {
        super.onStatusUpdate(status);
        SystemdLifecycle.notify(String.format("STATUS=%s", status));
    }

    private static synchronized void notify(String message) {
        int rv = Systemd.INSTANCE.sd_notify(0, message);
        if (rv < 0) {
            LOGGER.log(Level.WARNING, "sd_notify(3) returned {0}", rv);
        }
    }

    static interface Systemd
    extends Library {
        public static final Systemd INSTANCE = (Systemd)Native.load((String)"systemd", Systemd.class);

        public int sd_notify(int var1, String var2);
    }
}

