/*
 * Decompiled with CFR 0.152.
 */
package hudson.console;

import hudson.MarkupText;
import hudson.console.ConsoleAnnotator;
import hudson.console.ConsoleNote;
import hudson.console.LineTransformationOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.SourceCodeEscapers;
import org.apache.commons.io.output.ProxyWriter;
import org.kohsuke.stapler.framework.io.WriterOutputStream;

public class ConsoleAnnotationOutputStream<T>
extends LineTransformationOutputStream {
    private final Writer out;
    private final T context;
    private ConsoleAnnotator<T> ann;
    private final LineBuffer line = new LineBuffer(4096);
    private final WriterOutputStream lineOut;
    private static final Logger LOGGER = Logger.getLogger(ConsoleAnnotationOutputStream.class.getName());

    public ConsoleAnnotationOutputStream(Writer out, ConsoleAnnotator<? super T> ann, T context, Charset charset) {
        this.out = out;
        this.ann = ConsoleAnnotator.cast(ann);
        this.context = context;
        this.lineOut = new WriterOutputStream((Writer)((Object)this.line), charset);
    }

    public ConsoleAnnotator<T> getConsoleAnnotator() {
        return this.ann;
    }

    @Override
    protected void eol(byte[] in, int sz) throws IOException {
        this.line.reset();
        StringBuffer strBuf = this.line.getStringBuffer();
        int next = ConsoleNote.findPreamble(in, 0, sz);
        ArrayList<1> annotators = null;
        int written = 0;
        while (next >= 0) {
            if (next > written) {
                this.lineOut.write(in, written, next - written);
                this.lineOut.flush();
                written = next;
            } else assert (next == written);
            final int charPos = strBuf.length();
            int rest = sz - next;
            ByteArrayInputStream b = new ByteArrayInputStream(in, next, rest);
            try {
                final ConsoleNote a = ConsoleNote.readFrom(new DataInputStream(b));
                if (a != null) {
                    if (annotators == null) {
                        annotators = new ArrayList<1>();
                    }
                    annotators.add(new ConsoleAnnotator<T>(){

                        @Override
                        public ConsoleAnnotator<T> annotate(T context, MarkupText text) {
                            return a.annotate(context, text, charPos);
                        }
                    });
                }
            }
            catch (IOException | ClassNotFoundException e) {
                LOGGER.log(Level.FINE, "Failed to resurrect annotation from \"" + SourceCodeEscapers.javaCharEscaper().escape(new String(in, next, rest, Charset.defaultCharset())) + "\"", e);
            }
            int bytesUsed = rest - b.available();
            next = ConsoleNote.findPreamble(in, written += bytesUsed, sz - written);
        }
        this.lineOut.write(in, written, sz - written);
        if (annotators != null) {
            if (this.ann != null) {
                annotators.add(this.ann);
            }
            this.ann = ConsoleAnnotator.combine(annotators);
        }
        this.lineOut.flush();
        MarkupText mt = new MarkupText(strBuf.toString());
        if (this.ann != null) {
            this.ann = this.ann.annotate(this.context, mt);
        }
        this.out.write(mt.toString(true));
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.out.close();
    }

    private static class LineBuffer
    extends ProxyWriter {
        private LineBuffer(int initialSize) {
            super((Writer)new StringWriter(initialSize));
        }

        private void reset() {
            StringBuffer buf = this.getStringBuffer();
            if (buf.length() > 65536) {
                this.out = new StringWriter(4096);
            } else {
                buf.setLength(0);
            }
        }

        private StringBuffer getStringBuffer() {
            StringWriter w = (StringWriter)this.out;
            return w.getBuffer();
        }
    }
}

