/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import jakarta.servlet.ServletException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.kohsuke.stapler.AnnotationHandler;
import org.kohsuke.stapler.InjectedParameter;
import org.kohsuke.stapler.StaplerRequest2;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
@Documented
@InjectedParameter(value=HandlerImpl.class)
public @interface QueryParameter {
    public String value() default "";

    public boolean required() default false;

    public boolean fixEmpty() default false;

    public static class HandlerImpl
    extends AnnotationHandler<QueryParameter> {
        @Override
        public Object parse(StaplerRequest2 request, QueryParameter a, Class type, String parameterName) throws ServletException {
            String name = a.value();
            if (name.isEmpty()) {
                name = parameterName;
            }
            if (name == null) {
                throw new IllegalArgumentException("Parameter name unavailable neither in the code nor in annotation");
            }
            String value = request.getParameter(name);
            if (a.required() && value == null) {
                throw new ServletException("Required Query parameter " + name + " is missing");
            }
            if (a.fixEmpty() && value != null && value.isEmpty()) {
                value = null;
            }
            return this.convert(type, value);
        }
    }
}

