/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.SerializedInvoker;

public class ByteChannelContentSource
implements Content.Source {
    private final AutoLock lock = new AutoLock();
    private final SerializedInvoker _invoker = new SerializedInvoker(ByteChannelContentSource.class);
    private final ByteBufferPool.Sized _byteBufferPool;
    private ByteChannel _byteChannel;
    private final long _offset;
    private final long _length;
    private RetainableByteBuffer _buffer;
    private long _offsetRemaining;
    private long _totalRead;
    private Runnable demandCallback;
    private Content.Chunk _terminal;

    public ByteChannelContentSource(ByteBufferPool.Sized byteBufferPool, ByteChannel byteChannel) {
        this(byteBufferPool, byteChannel, 0L, -1L);
    }

    public ByteChannelContentSource(ByteBufferPool.Sized byteBufferPool, ByteChannel byteChannel, long offset, long length) {
        this._byteBufferPool = Objects.requireNonNullElse(byteBufferPool, ByteBufferPool.SIZED_NON_POOLING);
        this._byteChannel = byteChannel;
        this._offset = offset;
        this._length = TypeUtil.checkOffsetLengthSize(offset, length, -1L);
        this._offsetRemaining = offset;
    }

    protected ByteChannel open() throws IOException {
        return this._byteChannel;
    }

    @Override
    public void demand(Runnable demandCallback) {
        try (AutoLock ignored = this.lock.lock();){
            if (this.demandCallback != null) {
                throw new IllegalStateException("demand pending");
            }
            this.demandCallback = demandCallback;
        }
        this._invoker.run(this::invokeDemandCallback);
    }

    private void invokeDemandCallback() {
        Runnable demandCallback;
        try (AutoLock ignored = this.lock.lock();){
            demandCallback = this.demandCallback;
            this.demandCallback = null;
        }
        if (demandCallback != null) {
            ExceptionUtil.run(demandCallback, this::fail);
        }
    }

    protected void lockedSetTerminal(Content.Chunk terminal) {
        assert (this.lock.isHeldByCurrentThread());
        if (this._terminal == null) {
            this._terminal = Objects.requireNonNull(terminal);
        } else {
            ExceptionUtil.addSuppressedIfNotAssociated(this._terminal.getFailure(), terminal.getFailure());
        }
        IO.close(this._byteChannel);
        if (this._buffer != null) {
            this._buffer.release();
        }
        this._buffer = null;
    }

    private void lockedEnsureOpenOrTerminal() {
        assert (this.lock.isHeldByCurrentThread());
        if (!(this._terminal != null || this._byteChannel != null && this._byteChannel.isOpen())) {
            try {
                this._byteChannel = this.open();
                if (this._byteChannel == null || !this._byteChannel.isOpen()) {
                    this.lockedSetTerminal(Content.Chunk.from(new ClosedChannelException(), true));
                } else {
                    ByteChannel byteChannel = this._byteChannel;
                    if (byteChannel instanceof SeekableByteChannel) {
                        SeekableByteChannel seekableByteChannel = (SeekableByteChannel)byteChannel;
                        seekableByteChannel.position(this._offset);
                        this._offsetRemaining = 0L;
                    }
                }
            }
            catch (IOException e) {
                this.lockedSetTerminal(Content.Chunk.from(e, true));
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Content.Chunk read() {
        try (AutoLock ignored = this.lock.lock();){
            block27: {
                ByteBuffer byteBuffer;
                block28: {
                    int read;
                    block26: {
                        this.lockedEnsureOpenOrTerminal();
                        if (this._terminal != null) {
                            Content.Chunk chunk = this._terminal;
                            if (ignored == null) return chunk;
                            ignored.close();
                            return chunk;
                        }
                        if (this._length == 0L) {
                            this.lockedSetTerminal(Content.Chunk.EOF);
                            Content.Chunk chunk = Content.Chunk.EOF;
                            if (ignored == null) return chunk;
                            ignored.close();
                            return chunk;
                        }
                        if (this._buffer == null) {
                            this._buffer = this._byteBufferPool.acquire();
                        } else if (this._buffer.isRetained()) {
                            this._buffer.release();
                            this._buffer = this._byteBufferPool.acquire();
                        }
                        byteBuffer = this._buffer.getByteBuffer();
                        if (this._offsetRemaining > 0L) {
                            while (this._offsetRemaining > 0L) {
                                BufferUtil.clearToFill(byteBuffer);
                                byteBuffer.limit((int)Math.min((long)this._buffer.capacity(), this._offsetRemaining));
                                read = this._byteChannel.read(byteBuffer);
                                if (read < 0) {
                                    this.lockedSetTerminal(Content.Chunk.EOF);
                                    Content.Chunk chunk = this._terminal;
                                    if (ignored == null) return chunk;
                                    ignored.close();
                                    return chunk;
                                }
                                if (read == 0) {
                                    Content.Chunk chunk = null;
                                    if (ignored == null) return chunk;
                                    ignored.close();
                                    return chunk;
                                }
                                this._offsetRemaining -= (long)read;
                            }
                        }
                        BufferUtil.clearToFill(byteBuffer);
                        if (this._length > 0L) {
                            byteBuffer.limit((int)Math.min((long)this._buffer.capacity(), this._length - this._totalRead));
                        }
                        read = this._byteChannel.read(byteBuffer);
                        BufferUtil.flipToFlush(byteBuffer, 0);
                        if (read != 0) break block26;
                        Content.Chunk chunk = null;
                        if (ignored == null) return chunk;
                        ignored.close();
                        return chunk;
                        {
                            catch (Throwable t) {
                                this.lockedSetTerminal(Content.Chunk.from(t, true));
                                return this._terminal;
                            }
                        }
                    }
                    if (read <= 0) break block27;
                    this._totalRead += (long)read;
                    this._buffer.retain();
                    if (this._length >= 0L && this._totalRead >= this._length) break block28;
                    Content.Chunk chunk = Content.Chunk.asChunk(byteBuffer, false, this._buffer);
                    if (ignored == null) return chunk;
                    ignored.close();
                    return chunk;
                }
                Content.Chunk last = Content.Chunk.asChunk(byteBuffer, true, this._buffer);
                this.lockedSetTerminal(Content.Chunk.EOF);
                Content.Chunk chunk = last;
                if (ignored == null) return chunk;
                ignored.close();
                return chunk;
            }
            this.lockedSetTerminal(Content.Chunk.EOF);
            return this._terminal;
        }
    }

    @Override
    public void fail(Throwable failure) {
        try (AutoLock ignored = this.lock.lock();){
            this.lockedSetTerminal(Content.Chunk.from(failure, true));
        }
    }

    @Override
    public long getLength() {
        return this._length;
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean rewind() {
        AutoLock ignored;
        block15: {
            block14: {
                ignored = this.lock.lock();
                if (this._byteChannel instanceof SeekableByteChannel) break block14;
                boolean bl = false;
                if (ignored != null) {
                    ignored.close();
                }
                return bl;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            if (this._terminal != null && !Content.Chunk.isFailure(this._terminal) && (this._byteChannel == null || this._byteChannel instanceof SeekableByteChannel)) {
                this._terminal = null;
            }
            this.lockedEnsureOpenOrTerminal();
            if (this._terminal == null && this._byteChannel != null && this._byteChannel.isOpen()) break block15;
            boolean bl = false;
            if (ignored != null) {
                ignored.close();
            }
            return bl;
        }
        try {
            ((SeekableByteChannel)this._byteChannel).position(this._offset);
            this._offsetRemaining = 0L;
            this._totalRead = 0L;
            boolean bl = true;
            if (ignored != null) {
                ignored.close();
            }
            return bl;
        }
        catch (Throwable t) {
            try {
                this.lockedSetTerminal(Content.Chunk.from(t, true));
                boolean bl = true;
                return bl;
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        }
    }

    public static class PathContentSource
    extends ByteChannelContentSource {
        private final Path _path;

        public PathContentSource(Path path) {
            this(null, path, 0L, -1L);
        }

        public PathContentSource(ByteBufferPool.Sized byteBufferPool, Path path) {
            this(byteBufferPool, path, 0L, -1L);
        }

        public PathContentSource(ByteBufferPool.Sized byteBufferPool, Path path, long offset, long length) {
            super(byteBufferPool, null, offset, TypeUtil.checkOffsetLengthSize(offset, length, PathContentSource.size(path)));
            this._path = path;
        }

        public Path getPath() {
            return this._path;
        }

        @Override
        protected ByteChannel open() throws IOException {
            return Files.newByteChannel(this._path, StandardOpenOption.READ);
        }

        private static long size(Path path) {
            try {
                return Files.size(path);
            }
            catch (IOException e) {
                return -1L;
            }
        }
    }
}

