/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server.internal;

import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import org.eclipse.jetty.http2.HTTP2Channel;
import org.eclipse.jetty.http2.HTTP2Stream;
import org.eclipse.jetty.http2.HTTP2StreamEndPoint;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerHTTP2StreamEndPoint
extends HTTP2StreamEndPoint
implements HTTP2Channel.Server {
    private static final Logger LOG = LoggerFactory.getLogger(ServerHTTP2StreamEndPoint.class);

    public ServerHTTP2StreamEndPoint(HTTP2Stream stream) {
        super(stream);
    }

    @Override
    public Runnable onDataAvailable() {
        this.processDataAvailable();
        return null;
    }

    @Override
    public Runnable onTrailer(HeadersFrame frame) {
        return null;
    }

    @Override
    public void onTimeout(TimeoutException timeout, BiConsumer<Runnable, Boolean> consumer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("idle timeout on {}", (Object)this, (Object)timeout);
        }
        boolean result = true;
        Connection connection = this.getConnection();
        if (connection != null) {
            result = connection.onIdleExpired(timeout);
        }
        Runnable r = null;
        if (result) {
            this.processFailure(timeout);
            r = () -> this.close(timeout);
        }
        consumer.accept(r, result);
    }

    @Override
    public Runnable onFailure(Throwable failure, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.atDebug().setCause(failure).log("failure on {}", (Object)this);
        }
        this.processFailure(failure);
        this.close(failure);
        return callback::succeeded;
    }

    @Override
    public boolean isIdle() {
        return false;
    }
}

