/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.generator;

import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.FrameType;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PriorityFrame;
import org.eclipse.jetty.http2.generator.FrameGenerator;
import org.eclipse.jetty.http2.generator.HeaderGenerator;
import org.eclipse.jetty.http2.generator.PriorityGenerator;
import org.eclipse.jetty.http2.hpack.HpackEncoder;
import org.eclipse.jetty.http2.hpack.HpackException;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;

public class HeadersGenerator
extends FrameGenerator {
    private final HpackEncoder encoder;
    private final int maxHeaderBlockFragment;
    private final PriorityGenerator priorityGenerator;

    public HeadersGenerator(HeaderGenerator headerGenerator, HpackEncoder encoder) {
        this(headerGenerator, encoder, 0);
    }

    public HeadersGenerator(HeaderGenerator headerGenerator, HpackEncoder encoder, int maxHeaderBlockFragment) {
        super(headerGenerator);
        this.encoder = encoder;
        this.maxHeaderBlockFragment = maxHeaderBlockFragment;
        this.priorityGenerator = new PriorityGenerator(headerGenerator);
    }

    @Override
    public int generate(RetainableByteBuffer.Mutable accumulator, Frame frame) throws HpackException {
        HeadersFrame headersFrame = (HeadersFrame)frame;
        return this.generateHeaders(accumulator, headersFrame.getStreamId(), headersFrame.getMetaData(), headersFrame.getPriority(), headersFrame.isEndStream());
    }

    public int generateHeaders(RetainableByteBuffer.Mutable accumulator, int streamId, MetaData metaData, PriorityFrame priority, boolean endStream) throws HpackException {
        if (streamId < 0) {
            throw new IllegalArgumentException("Invalid stream id: " + streamId);
        }
        int flags = 0;
        if (priority != null) {
            flags = 32;
        }
        if (endStream) {
            flags |= 1;
        }
        RetainableByteBuffer hpack = this.encode(this.encoder, metaData);
        BufferUtil.flipToFlush(hpack.getByteBuffer(), 0);
        int hpackLength = hpack.remaining();
        int maxHeaderBlock = this.getMaxFrameSize();
        if (this.maxHeaderBlockFragment > 0) {
            maxHeaderBlock = Math.min(maxHeaderBlock, this.maxHeaderBlockFragment);
        }
        if (hpackLength > maxHeaderBlock) {
            int start = accumulator.remaining();
            int length = maxHeaderBlock + (priority == null ? 0 : 5);
            this.generateHeader(accumulator, FrameType.HEADERS, length, flags, streamId);
            this.generatePriority(accumulator, priority);
            accumulator.add(hpack.slice(maxHeaderBlock));
            hpack.skip(maxHeaderBlock);
            while (hpack.remaining() > maxHeaderBlock) {
                this.generateHeader(accumulator, FrameType.CONTINUATION, maxHeaderBlock, 0, streamId);
                accumulator.add(hpack.slice(maxHeaderBlock));
                hpack.skip(maxHeaderBlock);
            }
            this.generateHeader(accumulator, FrameType.CONTINUATION, hpack.remaining(), 4, streamId);
            accumulator.add(hpack);
            return accumulator.remaining() - start;
        }
        int length = hpackLength + (priority == null ? 0 : 5);
        this.generateHeader(accumulator, FrameType.HEADERS, length, flags |= 4, streamId);
        this.generatePriority(accumulator, priority);
        accumulator.add(hpack);
        return 9 + length;
    }

    private void generatePriority(RetainableByteBuffer.Mutable buffer, PriorityFrame priority) {
        if (priority != null) {
            this.priorityGenerator.generatePriorityBody(buffer, priority.getStreamId(), priority.getParentStreamId(), priority.getWeight(), priority.isExclusive());
        }
    }
}

