/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.security.authentication;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import org.eclipse.jetty.ee9.nested.HttpChannel;
import org.eclipse.jetty.ee9.nested.Request;
import org.eclipse.jetty.ee9.nested.SessionHandler;
import org.eclipse.jetty.ee9.security.Authenticator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.server.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoginAuthenticator
implements Authenticator {
    private static final Logger LOG = LoggerFactory.getLogger(LoginAuthenticator.class);
    protected LoginService _loginService;
    protected IdentityService _identityService;
    private boolean _sessionRenewedOnAuthentication;
    private int _sessionMaxInactiveIntervalOnAuthentication;
    private boolean _proxy;

    protected LoginAuthenticator() {
    }

    public boolean isProxyMode() {
        return this._proxy;
    }

    public void setProxyMode(boolean proxy) {
        this._proxy = proxy;
    }

    public HttpHeader getAuthorizationHeader() {
        return this._proxy ? HttpHeader.PROXY_AUTHORIZATION : HttpHeader.AUTHORIZATION;
    }

    public HttpHeader getChallengeHeader() {
        return this._proxy ? HttpHeader.PROXY_AUTHENTICATE : HttpHeader.WWW_AUTHENTICATE;
    }

    public int getUnauthorizedStatusCode() {
        return this._proxy ? 407 : 401;
    }

    @Override
    public void prepareRequest(ServletRequest request) {
    }

    public UserIdentity login(String username, Object password, ServletRequest servletRequest) {
        Request baseRequest = Request.getBaseRequest(servletRequest);
        if (baseRequest == null) {
            return null;
        }
        UserIdentity user = this._loginService.login(username, password, baseRequest.getCoreRequest(), SessionHandler.ServletSessionApi.getOrCreateSession(servletRequest));
        if (user != null) {
            Request request = Request.getBaseRequest(servletRequest);
            if (request != null) {
                this.renewSession(request, request.getResponse());
            }
            return user;
        }
        return null;
    }

    public void logout(ServletRequest request) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpSession session = httpRequest.getSession(false);
        if (session == null) {
            return;
        }
        session.removeAttribute("org.eclipse.jetty.security.sessionCreatedSecure");
    }

    @Override
    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        this._loginService = configuration.getLoginService();
        if (this._loginService == null) {
            throw new IllegalStateException("No LoginService for " + String.valueOf(this) + " in " + String.valueOf(configuration));
        }
        this._identityService = configuration.getIdentityService();
        if (this._identityService == null) {
            throw new IllegalStateException("No IdentityService for " + String.valueOf(this) + " in " + String.valueOf(configuration));
        }
        this._sessionRenewedOnAuthentication = configuration.isSessionRenewedOnAuthentication();
        this._sessionMaxInactiveIntervalOnAuthentication = configuration.getSessionMaxInactiveIntervalOnAuthentication();
    }

    public LoginService getLoginService() {
        return this._loginService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpSession renewSession(HttpServletRequest request, HttpServletResponse response) {
        HttpSession httpSession = request.getSession(false);
        if (httpSession != null && (this._sessionRenewedOnAuthentication || this._sessionMaxInactiveIntervalOnAuthentication != 0)) {
            HttpSession httpSession2 = httpSession;
            synchronized (httpSession2) {
                if (this._sessionMaxInactiveIntervalOnAuthentication != 0) {
                    httpSession.setMaxInactiveInterval(this._sessionMaxInactiveIntervalOnAuthentication < 0 ? -1 : this._sessionMaxInactiveIntervalOnAuthentication);
                }
                if (this._sessionRenewedOnAuthentication && httpSession.getAttribute("org.eclipse.jetty.security.sessionCreatedSecure") != Boolean.TRUE) {
                    if (httpSession instanceof Session.API) {
                        Session.API api = (Session.API)((Object)httpSession);
                        Request baseRequest = Request.getBaseRequest(request);
                        if (baseRequest != null) {
                            httpSession.setAttribute("org.eclipse.jetty.security.sessionCreatedSecure", Boolean.TRUE);
                            HttpChannel httpChannel = baseRequest.getHttpChannel();
                            api.getSession().renewId(httpChannel.getCoreRequest(), httpChannel.getCoreResponse());
                            return httpSession;
                        }
                    }
                    LOG.warn("Unable to renew session {}", (Object)httpSession);
                    return httpSession;
                }
            }
        }
        return httpSession;
    }
}

