/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.invoke.CallSite;
import java.util.HashSet;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.TagLibrary;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.impl.DefaultTagFactory;
import org.apache.commons.jelly.impl.TagFactory;
import org.apache.commons.jelly.impl.TagScript;
import org.kohsuke.stapler.jelly.AdjunctTag;
import org.kohsuke.stapler.jelly.AttributeNameRewritingTagScript;
import org.kohsuke.stapler.jelly.BindTag;
import org.kohsuke.stapler.jelly.CompressTag;
import org.kohsuke.stapler.jelly.ContentTypeTag;
import org.kohsuke.stapler.jelly.CopyStreamTag;
import org.kohsuke.stapler.jelly.DoctypeTag;
import org.kohsuke.stapler.jelly.FindAncestorTag;
import org.kohsuke.stapler.jelly.HeaderTag;
import org.kohsuke.stapler.jelly.IncludeTag;
import org.kohsuke.stapler.jelly.IsUserInRoleTag;
import org.kohsuke.stapler.jelly.NbspTag;
import org.kohsuke.stapler.jelly.OutTag;
import org.kohsuke.stapler.jelly.ParentScopeTag;
import org.kohsuke.stapler.jelly.RedirectTag;
import org.kohsuke.stapler.jelly.SetHeaderTag;
import org.kohsuke.stapler.jelly.StatusCodeTag;
import org.kohsuke.stapler.jelly.StructuredMessageArgumentTag;
import org.kohsuke.stapler.jelly.StructuredMessageFormatTag;
import org.xml.sax.Attributes;

public class StaplerTagLibrary
extends TagLibrary {
    private static final String ONCE_TAG_KEY = "stapler.once";
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Exposed for tests")
    public static boolean DISABLE_INCLUDE_TAG_CLASS_ATTRIBUTE_REWRITING = false;

    public StaplerTagLibrary() {
        this.registerTag("adjunct", AdjunctTag.class);
        this.registerTag("bind", BindTag.class);
        this.registerTag("compress", CompressTag.class);
        this.registerTag("contentType", ContentTypeTag.class);
        this.registerTag("copyStream", CopyStreamTag.class);
        this.registerTag("doctype", DoctypeTag.class);
        this.registerTag("findAncestor", FindAncestorTag.class);
        this.registerTag("header", HeaderTag.class);
        this.registerTag("addHeader", HeaderTag.class);
        this.registerTag("setHeader", SetHeaderTag.class);
        this.registerTag("include", IncludeTag.class);
        this.registerTag("isUserInRole", IsUserInRoleTag.class);
        this.registerTag("nbsp", NbspTag.class);
        this.registerTag("out", OutTag.class);
        this.registerTag("parentScope", ParentScopeTag.class);
        this.registerTag("redirect", RedirectTag.class);
        this.registerTag("statusCode", StatusCodeTag.class);
        this.registerTag("structuredMessageArgument", StructuredMessageArgumentTag.class);
        this.registerTag("structuredMessageFormat", StructuredMessageFormatTag.class);
    }

    public TagScript createTagScript(String name, Attributes attributes) throws JellyException {
        if (name.equals("documentation")) {
            return new TagScript(){

                public void run(JellyContext context, XMLOutput output) throws JellyTagException {
                }

                public void setTagBody(Script tagBody) {
                }
            };
        }
        if (name.equals("getOutput")) {
            return new TagScript(){

                public void run(JellyContext context, XMLOutput output) throws JellyTagException {
                    context.setVariable(this.getAttribute("var").evaluateAsString(context), (Object)output);
                }
            };
        }
        if (name.equals("once")) {
            return new TagScript(){

                public void run(JellyContext context, XMLOutput output) throws JellyTagException {
                    String key;
                    HttpServletRequest request = (HttpServletRequest)context.getVariable("request2");
                    HashSet<CallSite> executedScripts = (HashSet<CallSite>)request.getAttribute(StaplerTagLibrary.ONCE_TAG_KEY);
                    if (executedScripts == null) {
                        executedScripts = new HashSet<CallSite>();
                        request.setAttribute(StaplerTagLibrary.ONCE_TAG_KEY, executedScripts);
                    }
                    if (executedScripts.add((CallSite)((Object)(key = this.getFileName() + ":" + this.getLineNumber() + ":" + this.getColumnNumber())))) {
                        this.getTagBody().run(context, output);
                    }
                }
            };
        }
        if (!DISABLE_INCLUDE_TAG_CLASS_ATTRIBUTE_REWRITING && name.equals("include")) {
            AttributeNameRewritingTagScript script = new AttributeNameRewritingTagScript("class", "clazz");
            script.setTagFactory((TagFactory)new DefaultTagFactory(IncludeTag.class));
            return script;
        }
        return super.createTagScript(name, attributes);
    }
}

