/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.define;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.impl.Attribute;
import org.apache.commons.jelly.impl.DynamicBeanTag;
import org.apache.commons.jelly.impl.TagFactory;
import org.apache.commons.jelly.tags.define.DefineTagSupport;
import org.apache.commons.jelly.util.ClassLoaderUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;

public class BeanTag
extends DefineTagSupport {
    private static final Log log = LogFactory.getLog(BeanTag.class);
    private static final Map EMPTY_MAP = new HashMap();
    private String name;
    private String className;
    private ClassLoader classLoader;
    private String varAttribute = "var";
    private Map attributes;

    public void addAttribute(Attribute attribute) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(attribute.getName(), attribute);
    }

    public void doTag(XMLOutput output) throws MissingAttributeException, JellyTagException {
        this.invokeBody(output);
        if (this.name == null) {
            throw new MissingAttributeException("name");
        }
        if (this.className == null) {
            throw new MissingAttributeException("className");
        }
        Class theClass = null;
        try {
            ClassLoader classLoader = this.getClassLoader();
            theClass = ClassLoaderUtils.loadClass((String)this.className, (ClassLoader)this.getClassLoader(), (boolean)this.getContext().getUseContextClassLoader(), ((Object)((Object)this)).getClass());
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Could not load class: " + this.className + " exception: " + e), (Throwable)e);
            throw new JellyTagException("Could not find class: " + this.className + " using ClassLoader: " + this.classLoader);
        }
        final Class beanClass = theClass;
        final Method invokeMethod = this.getInvokeMethod(theClass);
        final Map beanAttributes = this.attributes != null ? this.attributes : EMPTY_MAP;
        TagFactory factory = new TagFactory(){

            public Tag createTag(String name, Attributes attributes) {
                return new DynamicBeanTag(beanClass, beanAttributes, BeanTag.this.varAttribute, invokeMethod);
            }
        };
        this.getTagLibrary().registerBeanTag(this.name, factory);
        this.attributes = null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return ClassLoaderUtils.getClassLoader((ClassLoader)this.classLoader, (boolean)this.getContext().getUseContextClassLoader(), ((Object)((Object)this)).getClass());
    }

    public void setVarAttribute(String varAttribute) {
        this.varAttribute = varAttribute;
    }

    protected Method getInvokeMethod(Class theClass) {
        return null;
    }
}

