/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.remoting.Channel;
import hudson.remoting.RemoteClassLoader;
import hudson.remoting.RemoteInvocationHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class ImportedClassLoaderTable {
    final Channel channel;
    final Map<RemoteClassLoader.IClassLoader, ClassLoader> classLoaders = new ConcurrentHashMap<RemoteClassLoader.IClassLoader, ClassLoader>();

    ImportedClassLoaderTable(Channel channel) {
        this.channel = channel;
    }

    @NonNull
    public ClassLoader get(int oid) {
        return this.get(RemoteInvocationHandler.wrap(this.channel, oid, RemoteClassLoader.IClassLoader.class, false, false, false, false));
    }

    @NonNull
    public ClassLoader get(@NonNull RemoteClassLoader.IClassLoader classLoaderProxy) {
        return this.classLoaders.computeIfAbsent(classLoaderProxy, proxy -> RemoteClassLoader.create(this.channel.baseClassLoader, proxy));
    }
}

