# FSharpPlus

[![Download](https://img.shields.io/nuget/dt/FSharpPlus.svg)](https://www.nuget.org/packages/FSharpPlus)
[![NuGet](https://img.shields.io/nuget/v/FSharpPlus.svg)](https://www.nuget.org/packages/FSharpPlus)
[![NuGet Preview](https://img.shields.io/nuget/vpre/FSharpPlus.svg?label=pre)](https://www.nuget.org/packages/FSharpPlus/absoluteLatest)
![Made with F#](https://img.shields.io/github/languages/top/fsprojects/FSharpPlus?color=%23b845fc)
![License - Apache 2.0](https://img.shields.io/github/license/fsprojects/FSharpPlus?color=%23FF957D)


F#+ is a base library that aims to take F# to the next level of functional
programming.

*What if we imagine F# as more than it is?*

F#+ builds upon FSharp, using generic programming techniques to help
you avoid boiler plate code.  However, by naming conventions and signatures
it can be seen to 'enhance' rather than 'replace' existing patterns as much
as possible.

Getting started is easy since you can start with enjoying some of the extensions
and generic functions, but you will find other parts of F#+ unfold before you
and become useful the deeper in you get.

See the [documentation](//fsprojects.github.io/FSharpPlus) for more details.

## Seeking Help

We're happy to help with any questions, including complete beginners!

Please do join us to chat on:

- Gitter
  [![Join the chat at https://gitter.im/fsprojects/FSharpPlus](https://badges.gitter.im/fsprojects/FSharpPlus.svg)](https://gitter.im/fsprojects/FSharpPlus?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)
- You can get invited into the [functional programming Slack](https://app.slack.com/client/T0432GV8P/CTT70ER47) and then join [#FSharpPlus](https://functionalprogramming.slack.com/join/shared_invite/zt-svowkzcg-6xzAuVrUtINX7swWuhjHUw#/shared-invite/email)

...or you can [ask a question on stack overflow](https://stackoverflow.com/questions/ask?tags=f%23%2b)
with tag `F#+`

## Contribute

The project is hosted on GitHub where you can report issues, fork the project and submit pull requests.
Opening issues for discussion or asking questions is welcome, don't hesitate to fill the [New Issue](issues/new) form!

* The [Developer Guide](DEVELOPER_GUIDE.md) contains details about idioms of implementation in terms of how the type class concept translates in the implementation.
* The [Design Guidelines](DESIGN_GUIDELINES.md) contains details about design choices guiding the implementation with regard to naming, and choices impacting runtime and compile time performance.
