/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.object;

import java.util.Objects;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.object.AbstractObjectMorpher;

public final class CharacterObjectMorpher
extends AbstractObjectMorpher {
    private Character defaultValue;

    public CharacterObjectMorpher() {
    }

    public CharacterObjectMorpher(Character defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CharacterObjectMorpher)) {
            return false;
        }
        CharacterObjectMorpher other = (CharacterObjectMorpher)obj;
        if (this.isUseDefault() && other.isUseDefault()) {
            return Objects.equals(this.getDefaultValue(), other.getDefaultValue());
        }
        return !this.isUseDefault() && !other.isUseDefault();
    }

    public Character getDefaultValue() {
        return this.defaultValue;
    }

    public int hashCode() {
        if (this.isUseDefault()) {
            return Objects.hashCode(this.getDefaultValue());
        }
        return 17;
    }

    @Override
    public Object morph(Object value) {
        if (value == null) {
            if (this.isUseDefault()) {
                return this.defaultValue;
            }
            throw new MorphException("value is null");
        }
        if (value instanceof Character) {
            return value;
        }
        String s = String.valueOf(value);
        if (!s.isEmpty()) {
            return Character.valueOf(s.charAt(0));
        }
        if (this.isUseDefault()) {
            return this.defaultValue;
        }
        throw new MorphException("Can't morph value: " + String.valueOf(value));
    }

    @Override
    public Class morphsTo() {
        return Character.class;
    }
}

