/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.object;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.object.AbstractObjectMorpher;

public final class BigDecimalMorpher
extends AbstractObjectMorpher {
    private BigDecimal defaultValue;

    public BigDecimalMorpher() {
    }

    public BigDecimalMorpher(BigDecimal defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BigDecimalMorpher)) {
            return false;
        }
        BigDecimalMorpher other = (BigDecimalMorpher)obj;
        if (this.isUseDefault() && other.isUseDefault()) {
            return Objects.equals(this.getDefaultValue(), other.getDefaultValue());
        }
        return !this.isUseDefault() && !other.isUseDefault();
    }

    public BigDecimal getDefaultValue() {
        return this.defaultValue;
    }

    public int hashCode() {
        if (this.isUseDefault()) {
            return Objects.hashCode(this.getDefaultValue());
        }
        return 17;
    }

    @Override
    public Object morph(Object value) {
        if (value instanceof BigDecimal) {
            return value;
        }
        if (value == null) {
            if (this.isUseDefault()) {
                return this.defaultValue;
            }
            return null;
        }
        if (value instanceof Number) {
            if (value instanceof Float) {
                Float f = (Float)value;
                if (f.isInfinite() || f.isNaN()) {
                    throw new MorphException("BigDecimal can not be infinite or NaN");
                }
            } else if (value instanceof Double) {
                Double d = (Double)value;
                if (d.isInfinite() || d.isNaN()) {
                    throw new MorphException("BigDecimal can not be infinite or NaN");
                }
            } else if (value instanceof BigInteger) {
                return new BigDecimal((BigInteger)value);
            }
            return new BigDecimal(((Number)value).doubleValue());
        }
        try {
            String str = String.valueOf(value).trim();
            if (str.length() == 0 || str.equalsIgnoreCase("null")) {
                return null;
            }
            return new BigDecimal(str);
        }
        catch (NumberFormatException nfe) {
            if (this.isUseDefault()) {
                return this.defaultValue;
            }
            throw new MorphException(nfe);
        }
    }

    @Override
    public Class morphsTo() {
        return BigDecimal.class;
    }
}

