/*
 * Decompiled with CFR 0.152.
 */
package jenkins.views;

import hudson.ExtensionList;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.util.AdministrativeError;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.views.Header;

public abstract class PartialHeader
extends Header {
    private static Logger LOGGER = Logger.getLogger(PartialHeader.class.getName());
    private static final int compatibilityHeaderVersion = 2;

    @Override
    public final boolean isCompatible() {
        return 2 == this.getSupportedHeaderVersion();
    }

    public abstract int getSupportedHeaderVersion();

    @Initializer(after=InitMilestone.JOB_LOADED, before=InitMilestone.JOB_CONFIG_ADAPTED)
    public static void incompatibleHeaders() {
        ExtensionList.lookup(PartialHeader.class).stream().filter(h -> !h.isCompatible()).forEach(header -> {
            LOGGER.warning(String.format("%s:%s not compatible with %s", header.getClass().getName(), header.getSupportedHeaderVersion(), 2));
            new AdministrativeError(header.getClass().getName(), "Incompatible Header", String.format("The plugin %s is attempting to replace the Jenkins header but is not compatible with this version of Jenkins. The plugin should be updated or removed.", Jenkins.get().getPluginManager().whichPlugin(header.getClass())), null);
        });
    }
}

