/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import groovy.lang.Binding;
import hudson.ExtensionPoint;
import hudson.model.User;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import jenkins.util.Listeners;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public interface ScriptListener
extends ExtensionPoint {
    default public void onScriptExecution(@CheckForNull String script, @CheckForNull Binding binding, @NonNull Object feature, @CheckForNull Object context, @NonNull String correlationId, @CheckForNull User user) {
    }

    default public void onScriptOutput(@CheckForNull String output, @NonNull Object feature, @CheckForNull Object context, @NonNull String correlationId, @CheckForNull User user) {
    }

    public static void fireScriptExecution(@CheckForNull String script, @CheckForNull Binding binding, @NonNull Object feature, @CheckForNull Object context, @NonNull String correlationId, @CheckForNull User user) {
        Listeners.notify(ScriptListener.class, true, listener -> listener.onScriptExecution(script, binding, feature, context, correlationId, user));
    }

    public static void fireScriptOutput(@CheckForNull String output, @NonNull Object feature, @CheckForNull Object context, @NonNull String correlationId, @CheckForNull User user) {
        Listeners.notify(ScriptListener.class, true, listener -> listener.onScriptOutput(output, feature, context, correlationId, user));
    }

    @Restricted(value={NoExternalUse.class})
    public static class ListenerOutputStream
    extends OutputStream {
        private final OutputStream os;
        private final Charset charset;
        private final Object feature;
        private final Object context;
        private final String correlationId;
        private final User user;

        public ListenerOutputStream(OutputStream os, Charset charset, Object feature, Object context, String correlationId, User user) {
            this.os = os;
            this.charset = charset;
            this.feature = feature;
            this.context = context;
            this.correlationId = correlationId;
            this.user = user;
        }

        @Override
        public void write(int b) throws IOException {
            ScriptListener.fireScriptOutput(new String(new byte[]{(byte)b}, this.charset), this.feature, this.context, this.correlationId, this.user);
            this.os.write(b);
        }

        @Override
        public void write(@NonNull byte[] b, int off, int len) throws IOException {
            String writtenString = new String(b, this.charset).substring(off, len - off);
            ScriptListener.fireScriptOutput(writtenString, this.feature, this.context, this.correlationId, this.user);
            this.os.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.os.flush();
        }

        @Override
        public void close() throws IOException {
            this.os.close();
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static class ListenerWriter
    extends Writer {
        private final Writer writer;
        private final Object feature;
        private final Object context;
        private final String correlationId;
        private final User user;

        public ListenerWriter(Writer writer, Object feature, Object context, String correlationId, User user) {
            this.writer = writer;
            this.feature = feature;
            this.context = context;
            this.correlationId = correlationId;
            this.user = user;
        }

        @Override
        public void write(@NonNull char[] cbuf, int off, int len) throws IOException {
            ScriptListener.fireScriptOutput(String.copyValueOf(cbuf, off, len), this.feature, this.context, this.correlationId, this.user);
            this.writer.write(cbuf, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.writer.flush();
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }
}

