/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.PersistentDescriptor;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.List;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.security.QueueItemAuthenticator;
import jenkins.security.QueueItemAuthenticatorDescriptor;
import jenkins.security.QueueItemAuthenticatorProvider;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
@Symbol(value={"queueItemAuthenticator"})
public class QueueItemAuthenticatorConfiguration
extends GlobalConfiguration
implements PersistentDescriptor {
    private final DescribableList<QueueItemAuthenticator, QueueItemAuthenticatorDescriptor> authenticators = new DescribableList(this);

    private Object readResolve() {
        this.authenticators.setOwner(this);
        return this;
    }

    @Override
    @NonNull
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(GlobalConfigurationCategory.Security.class);
    }

    public DescribableList<QueueItemAuthenticator, QueueItemAuthenticatorDescriptor> getAuthenticators() {
        return this.authenticators;
    }

    @Override
    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        try {
            this.authenticators.rebuildHetero(req, json, QueueItemAuthenticatorDescriptor.all(), "authenticators");
            return true;
        }
        catch (IOException e) {
            throw new Descriptor.FormException(e, "authenticators");
        }
    }

    @NonNull
    public static QueueItemAuthenticatorConfiguration get() {
        return GlobalConfiguration.all().getInstance(QueueItemAuthenticatorConfiguration.class);
    }

    @Extension(ordinal=100.0)
    public static class ProviderImpl
    extends QueueItemAuthenticatorProvider {
        @Override
        @NonNull
        public List<QueueItemAuthenticator> getAuthenticators() {
            return QueueItemAuthenticatorConfiguration.get().getAuthenticators();
        }
    }
}

