/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.init.InitMilestone;
import hudson.init.Initializer;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class JettySameSiteCookieSetup {
    private static final Logger LOGGER = Logger.getLogger(JettySameSiteCookieSetup.class.getName());

    @Initializer(before=InitMilestone.COMPLETED, after=InitMilestone.PLUGINS_PREPARED)
    public static void setUpCookie() {
        String key = JettySameSiteCookieSetup.class.getName() + ".sameSiteDefault";
        if ("".equals(SystemProperties.getString(key))) {
            LOGGER.log(Level.CONFIG, "Not setting a SameSite default value for cookies in Jetty");
            return;
        }
        String value = SystemProperties.getString(key, "Lax");
        Jenkins.get().getServletContext().setAttribute("org.eclipse.jetty.cookie.sameSiteDefault", (Object)value);
        LOGGER.log(Level.CONFIG, () -> "Setting SameSite default value for cookies in Jetty: " + value);
    }
}

