/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Util;
import hudson.model.User;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import jenkins.model.GlobalConfiguration;
import jenkins.security.ApiTokenProperty;
import jenkins.security.apitoken.ApiTokenPropertyConfiguration;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class BasicApiTokenHelper {
    @CheckForNull
    public static User isConnectingUsingApiToken(String username, String tokenValue) {
        User user = User.getById(username, false);
        if (user == null) {
            String generatedTokenOnCreation;
            boolean areTokenEqual;
            ApiTokenPropertyConfiguration apiTokenConfiguration = GlobalConfiguration.all().getInstance(ApiTokenPropertyConfiguration.class);
            if (apiTokenConfiguration.isTokenGenerationOnCreationEnabled() && (areTokenEqual = MessageDigest.isEqual((generatedTokenOnCreation = Util.getDigestOf(ApiTokenProperty.API_KEY_SEED.mac(username))).getBytes(StandardCharsets.US_ASCII), tokenValue.getBytes(StandardCharsets.US_ASCII)))) {
                return User.getById(username, true);
            }
        } else {
            ApiTokenProperty t = user.getProperty(ApiTokenProperty.class);
            if (t != null && t.matchesPassword(tokenValue)) {
                return user;
            }
        }
        return null;
    }
}

