/*
 * Decompiled with CFR 0.152.
 */
package jenkins.mvn;

import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import io.jenkins.servlet.ServletExceptionWrapper;
import javax.servlet.ServletException;
import jenkins.mvn.DefaultGlobalSettingsProvider;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;

public abstract class GlobalSettingsProvider
implements Describable<GlobalSettingsProvider>,
ExtensionPoint {
    public abstract FilePath supplySettings(AbstractBuild<?, ?> var1, TaskListener var2);

    public static GlobalSettingsProvider parseSettingsProvider(StaplerRequest2 req) throws Descriptor.FormException, jakarta.servlet.ServletException {
        JSONObject settings = req.getSubmittedForm().getJSONObject("globalSettings");
        if (settings == null) {
            return new DefaultGlobalSettingsProvider();
        }
        return (GlobalSettingsProvider)req.bindJSON(GlobalSettingsProvider.class, settings);
    }

    @Deprecated
    public static GlobalSettingsProvider parseSettingsProvider(StaplerRequest req) throws Descriptor.FormException, ServletException {
        try {
            return GlobalSettingsProvider.parseSettingsProvider(StaplerRequest.toStaplerRequest2((StaplerRequest)req));
        }
        catch (jakarta.servlet.ServletException e) {
            throw ServletExceptionWrapper.fromJakartaServletException((jakarta.servlet.ServletException)e);
        }
    }

    public static FilePath getSettingsFilePath(GlobalSettingsProvider settings, AbstractBuild<?, ?> build, TaskListener listener) {
        FilePath settingsPath = null;
        if (settings != null) {
            settingsPath = settings.supplySettings(build, listener);
        }
        return settingsPath;
    }

    public static String getSettingsRemotePath(GlobalSettingsProvider provider, AbstractBuild<?, ?> build, TaskListener listener) {
        FilePath fp = GlobalSettingsProvider.getSettingsFilePath(provider, build, listener);
        return fp == null ? null : fp.getRemote();
    }
}

