/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.PersistentDescriptor;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.StaplerRequest2;

@Extension(ordinal=401.0)
@Symbol(value={"computerRetentionCheckInterval"})
public class GlobalComputerRetentionCheckIntervalConfiguration
extends GlobalConfiguration
implements PersistentDescriptor {
    private int computerRetentionCheckInterval = 60;
    private static final Logger LOGGER = Logger.getLogger(GlobalComputerRetentionCheckIntervalConfiguration.class.getName());

    public int getComputerRetentionCheckInterval() {
        if (this.computerRetentionCheckInterval <= 0) {
            LOGGER.info("computerRetentionCheckInterval must be greater than zero, falling back to 60s");
            return 60;
        }
        if (this.computerRetentionCheckInterval > 60) {
            LOGGER.info("computerRetentionCheckInterval is limited to 60s");
            return 60;
        }
        return this.computerRetentionCheckInterval;
    }

    private void setComputerRetentionCheckInterval(int interval) throws IllegalArgumentException {
        if (interval <= 0) {
            throw new IllegalArgumentException("interval must be greater than zero");
        }
        if (interval > 60) {
            throw new IllegalArgumentException("interval must be below or equal 60s");
        }
        this.computerRetentionCheckInterval = interval;
        this.save();
    }

    @Override
    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        try {
            int interval = json.getInt("computerRetentionCheckInterval");
            this.setComputerRetentionCheckInterval(interval);
            return true;
        }
        catch (IllegalArgumentException e) {
            throw new Descriptor.FormException(e, "computerRetentionCheckInterval");
        }
        catch (JSONException e) {
            throw new Descriptor.FormException(e.getMessage(), "computerRetentionCheckInterval");
        }
    }
}

