/*
 * Decompiled with CFR 0.152.
 */
package jenkins.cli.listeners;

import hudson.AbortException;
import hudson.Extension;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.cli.listeners.CLIContext;
import jenkins.cli.listeners.CLIListener;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.args4j.CmdLineException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;

@Extension
@Restricted(value={NoExternalUse.class})
public class DefaultCLIListener
implements CLIListener {
    private static final Logger LOGGER = Logger.getLogger(DefaultCLIListener.class.getName());

    @Override
    public void onExecution(CLIContext context) {
        LOGGER.log(Level.FINE, "Invoking CLI command {0}, with {1} arguments, as user {2}.", new Object[]{context.getCommand(), context.getArgs().size(), DefaultCLIListener.authName(context.getAuth())});
    }

    @Override
    public void onCompleted(CLIContext context, int exitCode) {
        LOGGER.log(Level.FINE, "Executed CLI command {0}, with {1} arguments, as user {2}, return code {3}", new Object[]{context.getCommand(), context.getArgs().size(), DefaultCLIListener.authName(context.getAuth()), exitCode});
    }

    @Override
    public void onThrowable(CLIContext context, Throwable t) {
        if (t instanceof BadCredentialsException) {
            LOGGER.log(Level.INFO, "CLI login attempt failed: " + context.getCorrelationId(), t);
        } else if (t instanceof CmdLineException || t instanceof IllegalArgumentException || t instanceof IllegalStateException || t instanceof AbortException || t instanceof AccessDeniedException) {
            LOGGER.log(Level.FINE, String.format("Failed call to CLI command %s, with %d arguments, as user %s.", context.getCommand(), context.getArgs().size(), DefaultCLIListener.authName(context.getAuth())), t);
        } else {
            LOGGER.log(Level.WARNING, "Unexpected exception occurred while performing " + context.getCommand() + " command.", t);
        }
    }

    private static String authName(Authentication auth) {
        return auth != null ? auth.getName() : "<unknown>";
    }
}

