/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Functions;
import hudson.Util;
import hudson.util.FormValidation;
import hudson.util.Messages;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Locale;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public abstract class FormFillFailure
extends IOException
implements HttpResponse {
    private final FormValidation.Kind kind;
    private boolean selectionCleared;

    public static FormFillFailure error(@NonNull String message) {
        return FormFillFailure.errorWithMarkup(Util.escape(message));
    }

    public static FormFillFailure warning(@NonNull String message) {
        return FormFillFailure.warningWithMarkup(Util.escape(message));
    }

    public static FormFillFailure error(String format, Object ... args) {
        return FormFillFailure.error(String.format(format, args));
    }

    public static FormFillFailure warning(String format, Object ... args) {
        return FormFillFailure.warning(String.format(format, args));
    }

    public static FormFillFailure error(Throwable e, String message) {
        return FormFillFailure._error(FormValidation.Kind.ERROR, e, message);
    }

    public static FormFillFailure warning(Throwable e, String message) {
        return FormFillFailure._error(FormValidation.Kind.WARNING, e, message);
    }

    private static FormFillFailure _error(FormValidation.Kind kind, Throwable e, String message) {
        if (e == null) {
            return FormFillFailure._errorWithMarkup(Util.escape(message), kind);
        }
        return FormFillFailure._errorWithMarkup(Util.escape(message) + " </div><div><a href='#' class='showDetails'>" + Messages.FormValidation_Error_Details() + "</a><pre style='display:none'>" + Util.escape(Functions.printThrowable(e)) + "</pre>", kind);
    }

    public static FormFillFailure error(Throwable e, String format, Object ... args) {
        return FormFillFailure.error(e, String.format(format, args));
    }

    public static FormFillFailure warning(Throwable e, String format, Object ... args) {
        return FormFillFailure.warning(e, String.format(format, args));
    }

    public static FormFillFailure errorWithMarkup(String message) {
        return FormFillFailure._errorWithMarkup(message, FormValidation.Kind.ERROR);
    }

    public static FormFillFailure warningWithMarkup(String message) {
        return FormFillFailure._errorWithMarkup(message, FormValidation.Kind.WARNING);
    }

    private static FormFillFailure _errorWithMarkup(final @NonNull String message, final FormValidation.Kind kind) {
        return new FormFillFailure(kind, message){

            @Override
            public String renderHtml() {
                StaplerRequest2 req = Stapler.getCurrentRequest2();
                if (req == null) {
                    return message;
                }
                return "<div class=" + this.getKind().name().toLowerCase(Locale.ENGLISH) + ">" + message + "</div>";
            }

            @Override
            public String toString() {
                return String.valueOf((Object)kind) + ": " + message;
            }
        };
    }

    public static FormFillFailure respond(FormValidation.Kind kind, final String html) {
        return new FormFillFailure(kind){

            @Override
            public String renderHtml() {
                return html;
            }

            @Override
            public String toString() {
                return String.valueOf((Object)this.getKind()) + ": " + html;
            }
        };
    }

    private FormFillFailure(FormValidation.Kind kind) {
        this.kind = kind;
    }

    private FormFillFailure(FormValidation.Kind kind, String message) {
        super(message);
        this.kind = kind;
    }

    public void generateResponse(StaplerRequest2 req, StaplerResponse2 rsp, Object node) throws IOException, ServletException {
        rsp.setContentType("text/html;charset=UTF-8");
        rsp.setStatus(500);
        rsp.setHeader("X-Jenkins-Select-Error", this.selectionCleared ? "clear" : "retain");
        rsp.getWriter().print(this.renderHtml());
    }

    public FormValidation.Kind getKind() {
        return this.kind;
    }

    public boolean isSelectionCleared() {
        return this.selectionCleared;
    }

    public FormFillFailure withSelectionCleared() {
        this.selectionCleared = true;
        return this;
    }

    public abstract String renderHtml();
}

