/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import java.util.Objects;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public abstract class DelegatingClassLoader
extends ClassLoader {
    protected DelegatingClassLoader(String name, ClassLoader parent) {
        super(name, Objects.requireNonNull(parent));
    }

    public DelegatingClassLoader(ClassLoader parent) {
        super(Objects.requireNonNull(parent));
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = null;
        try {
            c = this.getParent().loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (c == null) {
            c = this.findClass(name);
        }
        this.verify(c);
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private void verify(Class<?> clazz) {
        if (clazz.getClassLoader() == this) {
            throw new IllegalStateException("DelegatingClassLoader must not be the defining loader: " + clazz.getName());
        }
    }
}

