/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.util.ErrorObject;
import jakarta.servlet.ServletContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.groovy.GroovyHookScript;
import org.kohsuke.stapler.WebApp;

public abstract class BootFailure
extends ErrorObject {
    private static final Logger LOGGER = Logger.getLogger(BootFailure.class.getName());

    protected BootFailure() {
    }

    protected BootFailure(Throwable cause) {
        super(cause);
    }

    public void publish(ServletContext context, @CheckForNull File home) {
        LOGGER.log(Level.SEVERE, "Failed to initialize Jenkins", this);
        WebApp.get((ServletContext)context).setApp((Object)this);
        if (home == null) {
            return;
        }
        new GroovyHookScript("boot-failure", context, home, BootFailure.class.getClassLoader()).bind("exception", this).bind("home", home).bind("servletContext", context).bind("attempts", this.loadAttempts(home)).run();
        Jenkins.get().getLifecycle().onBootFailure(this);
    }

    protected List<Date> loadAttempts(File home) {
        ArrayList<Date> dates;
        block12: {
            dates = new ArrayList<Date>();
            if (home != null) {
                File f = BootFailure.getBootFailureFile(home);
                try {
                    if (!f.exists()) break block12;
                    try (BufferedReader failureFileReader = Files.newBufferedReader(f.toPath(), Charset.defaultCharset());){
                        String line;
                        SimpleDateFormat df = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
                        while ((line = failureFileReader.readLine()) != null) {
                            try {
                                dates.add(df.parse(line));
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                catch (IOException | InvalidPathException e) {
                    LOGGER.log(Level.WARNING, "Failed to parse " + String.valueOf(f), e);
                }
            }
        }
        return dates;
    }

    public static File getBootFailureFile(File home) {
        return new File(home, "failed-boot-attempts.txt");
    }
}

