/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.Functions;
import java.io.Closeable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.SystemProperties;

public final class WorkspaceList {
    private final Map<String, Entry> inUse = new HashMap<String, Entry>();
    private static final Logger LOGGER = Logger.getLogger(WorkspaceList.class.getName());
    public static final String COMBINATOR = SystemProperties.getString(WorkspaceList.class.getName(), "@");
    public static final String TMP_DIR_SUFFIX = COMBINATOR + "tmp";

    public synchronized Lease allocate(@NonNull FilePath base) throws InterruptedException {
        return this.allocate(base, new Object());
    }

    public synchronized Lease allocate(@NonNull FilePath base, Object context) throws InterruptedException {
        int i = 1;
        FilePath candidate;
        Entry e;
        while ((e = this.inUse.get((candidate = i == 1 ? base : base.withSuffix(COMBINATOR + i)).getRemote())) != null && !e.quick && e.context != context) {
            ++i;
        }
        return this.acquire(candidate, false, context);
    }

    public synchronized Lease record(@NonNull FilePath p) {
        Entry old;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "recorded " + String.valueOf(p), new Throwable("from " + String.valueOf(this)));
        }
        if ((old = this.inUse.put(p.getRemote(), new Entry(p, false))) != null) {
            throw new AssertionError((Object)("Tried to record a workspace already owned: " + String.valueOf(old)));
        }
        return this.lease(p);
    }

    private synchronized void _release(@NonNull FilePath p) {
        Entry old = this.inUse.get(p.getRemote());
        if (old == null) {
            throw new AssertionError((Object)("Releasing unallocated workspace " + String.valueOf(p)));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "releasing " + String.valueOf(p) + " with lock count " + old.lockCount, new Throwable("from " + String.valueOf(this)));
        }
        --old.lockCount;
        if (old.lockCount == 0) {
            this.inUse.remove(p.getRemote());
        }
        this.notifyAll();
    }

    public synchronized Lease acquire(@NonNull FilePath p) throws InterruptedException {
        return this.acquire(p, false);
    }

    public synchronized Lease acquire(@NonNull FilePath p, boolean quick) throws InterruptedException {
        return this.acquire(p, quick, new Object());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Lease acquire(@NonNull FilePath p, boolean quick, Object context) throws InterruptedException {
        Entry e;
        Thread t = Thread.currentThread();
        String oldName = t.getName();
        t.setName("Waiting to acquire " + String.valueOf(p) + " : " + t.getName());
        try {
            while ((e = this.inUse.get(p.getRemote())) != null) {
                if (e.context == context) {
                    break;
                }
                this.wait();
            }
        }
        finally {
            t.setName(oldName);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "acquired " + String.valueOf(p) + (String)(e == null ? "" : " with lock count " + e.lockCount), new Throwable("from " + String.valueOf(this)));
        }
        if (e != null) {
            ++e.lockCount;
        } else {
            this.inUse.put(p.getRemote(), new Entry(p, quick, context));
        }
        return this.lease(p);
    }

    private Lease lease(@NonNull FilePath p) {
        return new Lease(p){
            final AtomicBoolean released;
            {
                this.released = new AtomicBoolean();
            }

            @Override
            public void release() {
                WorkspaceList.this._release(this.path);
            }

            @Override
            public void close() {
                if (this.released.compareAndSet(false, true)) {
                    this.release();
                }
            }
        };
    }

    @CheckForNull
    public static FilePath tempDir(FilePath ws) {
        return ws.sibling(ws.getName() + TMP_DIR_SUFFIX);
    }

    public static abstract class Lease
    implements Closeable {
        @NonNull
        public final FilePath path;

        protected Lease(@NonNull FilePath path) {
            if (path == null) {
                throw new NullPointerException("The specified FilePath is null");
            }
            this.path = path;
        }

        public abstract void release();

        @Override
        public void close() {
            this.release();
        }

        public static Lease createDummyLease(@NonNull FilePath p) {
            return new Lease(p){

                @Override
                public void release() {
                }
            };
        }

        public static Lease createLinkedDummyLease(@NonNull FilePath p, final Lease parent) {
            return new Lease(p){

                @Override
                public void release() {
                    parent.release();
                }
            };
        }
    }

    public static final class Entry {
        public final Thread holder = Thread.currentThread();
        public final long time = System.currentTimeMillis();
        public final Exception source = new AllocationAt();
        public final boolean quick;
        @NonNull
        public final FilePath path;
        public final Object context;
        public int lockCount = 1;

        private Entry(@NonNull FilePath path, boolean quick) {
            this(path, quick, new Object());
        }

        private Entry(@NonNull FilePath path, boolean quick, Object context) {
            this.path = path;
            this.quick = quick;
            this.context = context;
        }

        public String toString() {
            String s = String.valueOf(this.path) + " owned by " + this.holder.getName() + " from " + String.valueOf(new Date(this.time));
            if (this.quick) {
                s = s + " (quick)";
            }
            s = s + "\n" + Functions.printThrowable(this.source);
            return s;
        }
    }

    private static final class AllocationAt
    extends Exception {
        private AllocationAt() {
        }

        @Override
        public String toString() {
            return "Allocation Point";
        }
    }
}

