/*
 * Decompiled with CFR 0.152.
 */
package hudson.node_monitors;

import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import hudson.model.Computer;
import hudson.model.ComputerSet;
import hudson.model.TaskListener;
import hudson.node_monitors.MonitorMarkedNodeOffline;
import hudson.node_monitors.MonitorOfflineCause;
import hudson.node_monitors.NodeMonitor;
import hudson.slaves.ComputerListener;
import hudson.util.Futures;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import jenkins.util.Timer;

@Extension
public class NodeMonitorUpdater
extends ComputerListener {
    private static final Runnable MONITOR_UPDATER = new Runnable(){

        @Override
        public void run() {
            for (NodeMonitor nm : ComputerSet.getMonitors()) {
                nm.triggerUpdate();
            }
        }
    };
    private static final Runnable MARKEDOFFLINE_UPDATER = new Runnable(){

        @Override
        public void run() {
            MonitorMarkedNodeOffline no = AdministrativeMonitor.all().get(MonitorMarkedNodeOffline.class);
            if (no != null) {
                boolean markedOffline = false;
                for (Computer c : Jenkins.get().getComputers()) {
                    if (c.getChannel() == null || !(c.getOfflineCause() instanceof MonitorOfflineCause)) continue;
                    markedOffline = true;
                    break;
                }
                no.active = markedOffline;
            }
        }
    };
    private Future<?> future = Futures.precomputed(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onOnline(Computer c, TaskListener listener) throws IOException, InterruptedException {
        NodeMonitorUpdater nodeMonitorUpdater = this;
        synchronized (nodeMonitorUpdater) {
            this.future.cancel(false);
            this.future = Timer.get().schedule(MONITOR_UPDATER, 5L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTemporarilyOnline(Computer c) {
        NodeMonitorUpdater nodeMonitorUpdater = this;
        synchronized (nodeMonitorUpdater) {
            this.future.cancel(false);
            this.future = Timer.get().schedule(MARKEDOFFLINE_UPDATER, 5L, TimeUnit.SECONDS);
        }
    }
}

