/*
 * Decompiled with CFR 0.152.
 */
package hudson.model.labels;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Item;
import hudson.model.Label;
import hudson.model.Messages;
import hudson.model.labels.LabelAtom;
import hudson.model.labels.LabelOperatorPrecedence;
import hudson.model.labels.LabelVisitor;
import hudson.util.FormValidation;
import hudson.util.VariableResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import jenkins.model.Jenkins;
import jenkins.model.labels.LabelAutoCompleteSeeder;
import jenkins.model.labels.LabelValidator;

public abstract class LabelExpression
extends Label {
    protected LabelExpression(String name) {
        super(name);
    }

    @Override
    public String getExpression() {
        return this.getDisplayName();
    }

    static String paren(LabelOperatorPrecedence op, Label l) {
        if (op.compareTo(l.precedence()) < 0) {
            return "(" + l.getExpression() + ")";
        }
        return l.getExpression();
    }

    @NonNull
    public static AutoCompletionCandidates autoComplete(@Nullable String label) {
        AutoCompletionCandidates c = new AutoCompletionCandidates();
        Set<Label> labels = Jenkins.get().getLabels();
        List<String> queries = new LabelAutoCompleteSeeder(Util.fixNull(label)).getSeeds();
        for (String term : queries) {
            for (Label l : labels) {
                if (!l.getName().startsWith(term)) continue;
                c.add(l.getName());
            }
        }
        return c;
    }

    @NonNull
    public static FormValidation validate(@Nullable String expression) {
        return LabelExpression.validate(expression, null);
    }

    @NonNull
    public static FormValidation validate(@Nullable String expression, @CheckForNull Item item) {
        if (Util.fixEmptyAndTrim(expression) == null) {
            return FormValidation.ok();
        }
        try {
            Label.parseExpression(expression);
        }
        catch (IllegalArgumentException e) {
            return FormValidation.error(e, Messages.LabelExpression_InvalidBooleanExpression(e.getMessage()));
        }
        Jenkins j = Jenkins.get();
        Label l = j.getLabel(expression);
        if (l == null || l.isEmpty()) {
            Set<Object> labelAtoms;
            LabelAtom masterLabel = LabelAtom.get("master");
            Set<Object> set = labelAtoms = l == null ? Collections.emptySet() : l.listAtoms();
            if (!masterLabel.equals(Jenkins.get().getSelfLabel()) && labelAtoms.contains(masterLabel) && masterLabel.isEmpty()) {
                return FormValidation.warningWithMarkup(Messages.LabelExpression_ObsoleteMasterLabel());
            }
            for (LabelAtom labelAtom : labelAtoms) {
                if (!labelAtom.isEmpty()) continue;
                LabelAtom nearest = LabelAtom.findNearest(labelAtom.getName());
                return FormValidation.warning(Messages.LabelExpression_NoMatch_DidYouMean(labelAtom.getName(), nearest.getDisplayName()));
            }
            return FormValidation.warning(Messages.LabelExpression_NoMatch());
        }
        if (item != null) {
            ArrayList<FormValidation> problems = new ArrayList<FormValidation>();
            for (AbstractProject.LabelValidator labelValidator : j.getExtensionList(AbstractProject.LabelValidator.class)) {
                FormValidation formValidation = labelValidator.checkItem(item, l);
                if (FormValidation.Kind.OK.equals((Object)formValidation.kind)) continue;
                problems.add(formValidation);
            }
            for (LabelValidator labelValidator : j.getExtensionList(LabelValidator.class)) {
                FormValidation formValidation = labelValidator.check(item, l);
                if (FormValidation.Kind.OK.equals((Object)formValidation.kind)) continue;
                problems.add(formValidation);
            }
            if (!problems.isEmpty()) {
                return FormValidation.aggregate(problems);
            }
        }
        return FormValidation.okWithMarkup(Messages.LabelExpression_LabelLink(j.getRootUrl(), Util.escape(l.getName()), l.getUrl(), l.getNodes().size(), l.getClouds().size()));
    }

    public static final class Implies
    extends Binary {
        public Implies(Label lhs, Label rhs) {
            super(lhs, rhs, LabelOperatorPrecedence.IMPLIES);
        }

        @Override
        protected boolean op(boolean a, boolean b) {
            return !a || b;
        }

        @Override
        public <V, P> V accept(LabelVisitor<V, P> visitor, P param) {
            return visitor.onImplies(this, param);
        }

        @Override
        public LabelOperatorPrecedence precedence() {
            return LabelOperatorPrecedence.IMPLIES;
        }
    }

    public static final class Iff
    extends Binary {
        public Iff(Label lhs, Label rhs) {
            super(lhs, rhs, LabelOperatorPrecedence.IFF);
        }

        @Override
        protected boolean op(boolean a, boolean b) {
            return a == b;
        }

        @Override
        public <V, P> V accept(LabelVisitor<V, P> visitor, P param) {
            return visitor.onIff(this, param);
        }

        @Override
        public LabelOperatorPrecedence precedence() {
            return LabelOperatorPrecedence.IFF;
        }
    }

    public static final class Or
    extends Binary {
        public Or(Label lhs, Label rhs) {
            super(lhs, rhs, LabelOperatorPrecedence.OR);
        }

        @Override
        protected boolean op(boolean a, boolean b) {
            return a || b;
        }

        @Override
        public <V, P> V accept(LabelVisitor<V, P> visitor, P param) {
            return visitor.onOr(this, param);
        }

        @Override
        public LabelOperatorPrecedence precedence() {
            return LabelOperatorPrecedence.OR;
        }
    }

    public static final class And
    extends Binary {
        public And(Label lhs, Label rhs) {
            super(lhs, rhs, LabelOperatorPrecedence.AND);
        }

        @Override
        protected boolean op(boolean a, boolean b) {
            return a && b;
        }

        @Override
        public <V, P> V accept(LabelVisitor<V, P> visitor, P param) {
            return visitor.onAnd(this, param);
        }

        @Override
        public LabelOperatorPrecedence precedence() {
            return LabelOperatorPrecedence.AND;
        }
    }

    public static abstract class Binary
    extends LabelExpression {
        public final Label lhs;
        public final Label rhs;

        protected Binary(Label lhs, Label rhs, LabelOperatorPrecedence op) {
            super(Binary.combine(lhs, rhs, op));
            this.lhs = lhs;
            this.rhs = rhs;
        }

        private static String combine(Label lhs, Label rhs, LabelOperatorPrecedence op) {
            return Binary.paren(op, lhs) + op.str + Binary.paren(op, rhs);
        }

        @Override
        public boolean matches(VariableResolver<Boolean> resolver) {
            return this.op(this.lhs.matches(resolver), this.rhs.matches(resolver));
        }

        protected abstract boolean op(boolean var1, boolean var2);
    }

    public static class Paren
    extends LabelExpression {
        public final Label base;

        public Paren(Label base) {
            super("(" + base.getExpression() + ")");
            this.base = base;
        }

        @Override
        public boolean matches(VariableResolver<Boolean> resolver) {
            return this.base.matches(resolver);
        }

        @Override
        public <V, P> V accept(LabelVisitor<V, P> visitor, P param) {
            return visitor.onParen(this, param);
        }

        @Override
        public LabelOperatorPrecedence precedence() {
            return LabelOperatorPrecedence.ATOM;
        }
    }

    public static class Not
    extends LabelExpression {
        public final Label base;

        public Not(Label base) {
            super("!" + Not.paren(LabelOperatorPrecedence.NOT, base));
            this.base = base;
        }

        @Override
        public boolean matches(VariableResolver<Boolean> resolver) {
            return !this.base.matches(resolver);
        }

        @Override
        public <V, P> V accept(LabelVisitor<V, P> visitor, P param) {
            return visitor.onNot(this, param);
        }

        @Override
        public LabelOperatorPrecedence precedence() {
            return LabelOperatorPrecedence.NOT;
        }
    }
}

