/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.AsyncPeriodicWork;
import hudson.model.TaskListener;
import java.util.logging.Logger;
import jenkins.fingerprints.FileFingerprintStorage;
import jenkins.fingerprints.FingerprintStorage;
import jenkins.fingerprints.GlobalFingerprintConfiguration;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Symbol(value={"fingerprintCleanup"})
@Restricted(value={NoExternalUse.class})
public class FingerprintCleanupThread
extends AsyncPeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(FingerprintCleanupThread.class.getName());

    public FingerprintCleanupThread() {
        super("Fingerprint cleanup");
    }

    @Override
    public long getRecurrencePeriod() {
        return 86400000L;
    }

    public static void invoke() {
        FingerprintCleanupThread.getInstance().run();
    }

    private static FingerprintCleanupThread getInstance() {
        return ExtensionList.lookup(AsyncPeriodicWork.class).get(FingerprintCleanupThread.class);
    }

    @Override
    public void execute(TaskListener listener) {
        if (GlobalFingerprintConfiguration.get().isFingerprintCleanupDisabled()) {
            LOGGER.fine("Fingerprint cleanup is disabled. Skipping execution");
            return;
        }
        FingerprintStorage.get().iterateAndCleanupFingerprints(listener);
        FileFingerprintStorage fileFingerprintStorage = ExtensionList.lookupSingleton(FileFingerprintStorage.class);
        if (!(FingerprintStorage.get() instanceof FileFingerprintStorage) && fileFingerprintStorage.isReady()) {
            fileFingerprintStorage.iterateAndCleanupFingerprints(listener);
        }
    }
}

